/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.backend.sesame;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSesameBackend
implements RDFBackend<Value> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSesameBackend.class);

    public boolean supportsThreading() {
        return false;
    }

    public ThreadPoolExecutor getThreadPool() {
        return null;
    }

    public boolean isLiteral(Value n) {
        return n instanceof Literal;
    }

    public boolean isURI(Value n) {
        return n instanceof org.openrdf.model.URI;
    }

    public boolean isBlank(Value n) {
        return n instanceof BNode;
    }

    public Locale getLiteralLanguage(Value n) {
        try {
            if (((Literal)n).getLanguage() != null) {
                return new Locale(((Literal)n).getLanguage());
            }
            return null;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + n.stringValue() + " is not a literal" + "but of type " + this.debugType(n));
        }
    }

    public URI getLiteralType(Value n) {
        try {
            if (((Literal)n).getDatatype() != null) {
                try {
                    return new URI(((Literal)n).getDatatype().stringValue());
                }
                catch (URISyntaxException e) {
                    log.error("literal datatype was not a valid URI: {}", (Object)((Literal)n).getDatatype());
                    return null;
                }
            }
            return null;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + n.stringValue() + " is not a literal" + "but of type " + this.debugType(n));
        }
    }

    public String stringValue(Value value) {
        return value.stringValue();
    }

    public BigDecimal decimalValue(Value node) {
        try {
            return ((Literal)node).decimalValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    public BigInteger integerValue(Value node) {
        try {
            return ((Literal)node).integerValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    public Boolean booleanValue(Value node) {
        try {
            return ((Literal)node).booleanValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    public Date dateTimeValue(Value node) {
        try {
            XMLGregorianCalendar cal = ((Literal)node).calendarValue();
            return cal.toGregorianCalendar().getTime();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    public Date dateValue(Value node) {
        try {
            XMLGregorianCalendar cal = ((Literal)node).calendarValue();
            return new GregorianCalendar(cal.getYear(), cal.getMonth(), cal.getDay()).getTime();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    public Date timeValue(Value node) {
        return this.dateTimeValue(node);
    }

    public Long longValue(Value node) {
        try {
            return ((Literal)node).longValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    public Double doubleValue(Value node) {
        try {
            return ((Literal)node).doubleValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    public Float floatValue(Value node) {
        try {
            return Float.valueOf(((Literal)node).floatValue());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    public Integer intValue(Value node) {
        try {
            return ((Literal)node).intValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Value> listObjectsInternal(RepositoryConnection connection, Resource subject, org.openrdf.model.URI property) throws RepositoryException {
        HashSet<Value> result = new HashSet<Value>();
        RepositoryResult qResult = connection.getStatements(subject, property, null, true, new Resource[0]);
        try {
            while (qResult.hasNext()) {
                result.add(((Statement)qResult.next()).getObject());
            }
        }
        finally {
            qResult.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Value> listSubjectsInternal(RepositoryConnection connection, org.openrdf.model.URI property, Value object) throws RepositoryException {
        HashSet<Value> result = new HashSet<Value>();
        RepositoryResult qResult = connection.getStatements(null, property, object, true, new Resource[0]);
        try {
            while (qResult.hasNext()) {
                result.add((Value)((Statement)qResult.next()).getSubject());
            }
        }
        finally {
            qResult.close();
        }
        return result;
    }

    protected Value createURIInternal(ValueFactory valueFactory, String uri) {
        return valueFactory.createURI(uri);
    }

    protected Value createLiteralInternal(ValueFactory valueFactory, String content) {
        log.debug("creating literal with content \"{}\"", (Object)content);
        return valueFactory.createLiteral(content);
    }

    protected Value createLiteralInternal(ValueFactory valueFactory, String content, Locale language, URI type) {
        log.debug("creating literal with content \"{}\", language {}, datatype {}", new Object[]{content, language, type});
        if (language == null && type == null) {
            return valueFactory.createLiteral(content);
        }
        if (type == null) {
            return valueFactory.createLiteral(content, language.getLanguage());
        }
        return valueFactory.createLiteral(content, valueFactory.createURI(type.toString()));
    }

    protected String debugType(Value value) {
        return value == null ? "null" : (this.isURI(value) ? "URI" : (this.isBlank(value) ? "bNode" : "literal (" + this.getLiteralType(value) + ")"));
    }
}

