/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldcache.sail;

import info.aduna.iteration.CloseableIteration;
import org.apache.marmotta.commons.sesame.filter.SesameFilter;
import org.apache.marmotta.ldcache.services.LDCache;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.NotifyingSailConnectionWrapper;

public class KiWiLinkedDataSailConnection
extends NotifyingSailConnectionWrapper {
    private LDCache ldcache;
    private SesameFilter<Resource> acceptor;

    public KiWiLinkedDataSailConnection(NotifyingSailConnection wrappedCon, LDCache ldcache, SesameFilter<Resource> acceptor) {
        super(wrappedCon);
        this.ldcache = ldcache;
        this.acceptor = acceptor;
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (subj != null && this.isAcceptable(subj)) {
            this.ldcache.refreshResource((URI)subj, false);
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    private boolean isAcceptable(Resource resource) {
        if (resource instanceof BNode) {
            return false;
        }
        return this.acceptor.accept((Object)resource);
    }
}

