/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldcache.sail;

import org.apache.marmotta.commons.sesame.filter.SesameFilter;
import org.apache.marmotta.kiwi.sail.KiWiStore;
import org.apache.marmotta.ldcache.api.LDCachingBackend;
import org.apache.marmotta.ldcache.backend.kiwi.LDCachingKiWiBackend;
import org.apache.marmotta.ldcache.model.CacheConfiguration;
import org.apache.marmotta.ldcache.sail.KiWiLinkedDataSailConnection;
import org.apache.marmotta.ldcache.services.LDCache;
import org.apache.marmotta.ldclient.model.ClientConfiguration;
import org.openrdf.model.Resource;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.StackableSail;
import org.openrdf.sail.helpers.NotifyingSailWrapper;

public class KiWiLinkedDataSail
extends NotifyingSailWrapper {
    private KiWiStore store = this.getBaseStore();
    private LDCachingKiWiBackend backend;
    private LDCache ldcache;
    private SesameFilter<Resource> acceptor;
    private String cache_context;
    private CacheConfiguration config;

    public KiWiLinkedDataSail(NotifyingSail baseSail, SesameFilter<Resource> acceptor, String cacheContextUri) {
        this(baseSail, acceptor, cacheContextUri, null);
    }

    public KiWiLinkedDataSail(NotifyingSail baseSail, SesameFilter<Resource> acceptor, String cacheContextUri, ClientConfiguration clientConfiguration) {
        super(baseSail);
        this.cache_context = cacheContextUri;
        this.acceptor = acceptor;
        this.config = new CacheConfiguration();
        if (clientConfiguration != null) {
            this.config.setClientConfiguration(clientConfiguration);
        }
    }

    public void initialize() throws SailException {
        super.initialize();
        this.backend = new LDCachingKiWiBackend(this.store, this.cache_context);
        this.backend.initialize();
        this.ldcache = new LDCache(this.config, (LDCachingBackend)this.backend);
    }

    public void shutDown() throws SailException {
        this.ldcache.shutdown();
        this.backend.shutdown();
        super.shutDown();
    }

    public NotifyingSailConnection getConnection() throws SailException {
        return new KiWiLinkedDataSailConnection(super.getConnection(), this.ldcache, this.acceptor);
    }

    public KiWiStore getBaseStore() {
        KiWiLinkedDataSail current;
        for (current = this; current != null && current.getBaseSail() instanceof StackableSail; current = (StackableSail)current.getBaseSail()) {
        }
        if (current != null && current.getBaseSail() instanceof KiWiStore) {
            return (KiWiStore)current.getBaseSail();
        }
        throw new IllegalStateException("the base store is not a KiWiStore (type: " + current.getBaseSail().getClass().getCanonicalName() + ")!");
    }

    public LDCachingKiWiBackend getBackend() {
        return this.backend;
    }

    public LDCache getLDCache() {
        return this.ldcache;
    }
}

