/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.model.caching;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.marmotta.kiwi.model.caching.IntArray;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TripleTable<Triple extends Statement>
implements Set<Triple>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Set<Triple> data;
    private NavigableMap<IntArray, Triple> indexSPOC;
    private NavigableMap<IntArray, Triple> indexCSPO;

    public TripleTable() {
        this.data = new HashSet<Triple>();
        this.indexSPOC = new TreeMap<IntArray, Triple>();
        this.indexCSPO = new TreeMap<IntArray, Triple>();
    }

    public TripleTable(Collection<Triple> triples) {
        this.data = new HashSet<Triple>(triples.size());
        this.indexSPOC = new TreeMap<IntArray, Triple>();
        this.indexCSPO = new TreeMap<IntArray, Triple>();
        this.addAll((Collection<? extends Triple>)triples);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public Iterator<Triple> iterator() {
        return this.data.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    @Override
    public boolean add(Triple triple) {
        this.indexSPOC.put(IntArray.createSPOCKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext()), triple);
        this.indexCSPO.put(IntArray.createCSPOKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext()), triple);
        return this.data.add(triple);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Statement) {
            Statement triple = (Statement)o;
            this.indexSPOC.remove(IntArray.createSPOCKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext()));
            this.indexCSPO.remove(IntArray.createCSPOKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext()));
        }
        return this.data.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Triple> c) {
        boolean modified = false;
        for (Statement t : c) {
            modified = this.add((Triple)t) || modified;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator it = this.indexSPOC.entrySet().iterator();
        while (it.hasNext()) {
            if (c.contains(it.next().getValue())) continue;
            it.remove();
        }
        Iterator it2 = this.indexCSPO.entrySet().iterator();
        while (it2.hasNext()) {
            if (c.contains(it2.next().getValue())) continue;
            it2.remove();
        }
        return this.data.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified = this.remove(o) || modified;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.data.clear();
        this.indexSPOC.clear();
        this.indexCSPO.clear();
    }

    public Collection<Triple> listTriples(final Resource subject, final URI property, final Value object, final URI context) {
        if (subject != null && property != null && object != null && context != null) {
            IntArray key = IntArray.createSPOCKey(subject, property, object, (Resource)context);
            Statement result = (Statement)this.indexSPOC.get(key);
            if (result != null) {
                return Collections.singleton(result);
            }
            return Collections.emptyList();
        }
        if (subject != null && property != null && object != null || subject != null && property != null || subject != null) {
            IntArray fromKey = IntArray.createSPOCKey(subject, property, object, (Resource)context);
            IntArray toKey = IntArray.createSPOCMaxKey(subject, property, object, context);
            return this.indexSPOC.subMap(fromKey, true, toKey, true).values();
        }
        if (context != null && subject != null && property != null || context != null && subject != null || context != null) {
            IntArray fromKey = IntArray.createCSPOKey(subject, property, object, (Resource)context);
            IntArray toKey = IntArray.createCSPOMaxKey(subject, property, object, context);
            return this.indexCSPO.subMap(fromKey, true, toKey, true).values();
        }
        Predicate<Statement> p = new Predicate<Statement>(){

            public boolean apply(Statement triple) {
                if (subject != null && !triple.getSubject().equals(subject)) {
                    return false;
                }
                if (property != null && !triple.getPredicate().equals(property)) {
                    return false;
                }
                if (object != null && !triple.getObject().equals(object)) {
                    return false;
                }
                return context == null || triple.getContext().equals(context);
            }
        };
        return Sets.filter(this.data, (Predicate)p);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripleTable that = (TripleTable)o;
        return ((Object)this.data).equals(that.data);
    }

    @Override
    public int hashCode() {
        return ((Object)this.data).hashCode();
    }
}

