/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.model.caching;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public final class IntArray
implements Comparable<IntArray> {
    private static HashFunction hashFunction = Hashing.goodFastHash((int)32);
    private int[] data;
    private HashCode goodHashCode;

    public IntArray(int[] data) {
        this.data = data;
        Hasher hasher = hashFunction.newHasher();
        for (int i : data) {
            hasher.putInt(i);
        }
        this.goodHashCode = hasher.hash();
    }

    public static final IntArray createSPOCKey(Resource subject, URI property, Value object, Resource context) {
        int s = subject != null ? subject.hashCode() : Integer.MIN_VALUE;
        int p = property != null ? property.hashCode() : Integer.MIN_VALUE;
        int o = object != null ? object.hashCode() : Integer.MIN_VALUE;
        int c = context != null ? context.hashCode() : Integer.MIN_VALUE;
        IntBuffer bb = IntBuffer.allocate(4);
        bb.put(s);
        bb.put(p);
        bb.put(o);
        bb.put(c);
        return new IntArray(bb.array());
    }

    public static final IntArray createSPOCMaxKey(Resource subject, URI property, Value object, URI context) {
        int s = subject != null ? subject.hashCode() : Integer.MAX_VALUE;
        int p = property != null ? property.hashCode() : Integer.MAX_VALUE;
        int o = object != null ? object.hashCode() : Integer.MAX_VALUE;
        int c = context != null ? context.hashCode() : Integer.MAX_VALUE;
        IntBuffer bb = IntBuffer.allocate(4);
        bb.put(s);
        bb.put(p);
        bb.put(o);
        bb.put(c);
        return new IntArray(bb.array());
    }

    public static final IntArray createCSPOKey(Resource subject, URI property, Value object, Resource context) {
        int s = subject != null ? subject.hashCode() : Integer.MIN_VALUE;
        int p = property != null ? property.hashCode() : Integer.MIN_VALUE;
        int o = object != null ? object.hashCode() : Integer.MIN_VALUE;
        int c = context != null ? context.hashCode() : Integer.MIN_VALUE;
        IntBuffer bb = IntBuffer.allocate(4);
        bb.put(c);
        bb.put(s);
        bb.put(p);
        bb.put(o);
        return new IntArray(bb.array());
    }

    public static final IntArray createCSPOMaxKey(Resource subject, URI property, Value object, URI context) {
        int s = subject != null ? subject.hashCode() : Integer.MAX_VALUE;
        int p = property != null ? property.hashCode() : Integer.MAX_VALUE;
        int o = object != null ? object.hashCode() : Integer.MAX_VALUE;
        int c = context != null ? context.hashCode() : Integer.MAX_VALUE;
        IntBuffer bb = IntBuffer.allocate(4);
        bb.put(c);
        bb.put(s);
        bb.put(p);
        bb.put(o);
        return new IntArray(bb.array());
    }

    public String toString() {
        return "IntArray{data=" + Arrays.toString(this.data) + '}';
    }

    @Override
    public int compareTo(IntArray o) {
        for (int i = 0; i < this.data.length && i < o.data.length; ++i) {
            if (this.data[i] < o.data[i]) {
                return -1;
            }
            if (this.data[i] <= o.data[i]) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArray intArray = (IntArray)o;
        return Arrays.equals(this.data, intArray.data);
    }

    public int hashCode() {
        return this.goodHashCode.hashCode();
    }
}

