/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.logging;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.Socket;
import org.apache.isis.core.runtime.logging.SmtpSnapshotAppender;
import org.apache.isis.core.runtime.logging.SnapshotAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class SocketSnapshotAppender
extends SnapshotAppender {
    private static final Logger LOG = Logger.getLogger(SmtpSnapshotAppender.class);
    private int port = 9289;
    private String server;

    public SocketSnapshotAppender(TriggeringEventEvaluator evaluator) {
        super(evaluator);
    }

    public SocketSnapshotAppender() {
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServer(String mailServer) {
        if (mailServer == null) {
            throw new IllegalArgumentException("mail server not specified");
        }
        this.server = mailServer;
    }

    @Override
    protected void writeSnapshot(String message, String details) {
        try {
            if (this.server == null) {
                throw new IllegalStateException("mail server not specified");
            }
            Socket s = new Socket(this.server, this.port);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(s.getOutputStream(), "8859_1"));
            out.write(message + "\n");
            out.write(details + "\n");
            out.flush();
            s.close();
        }
        catch (ConnectException e) {
            LOG.info((Object)("failed to connect to server " + this.server));
        }
        catch (Exception e) {
            LOG.info((Object)"failed to send email with log", (Throwable)e);
        }
    }
}

