/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.logging;

import java.util.Date;
import org.apache.isis.core.runtime.logging.DefaultEvaluator;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public abstract class SnapshotAppender
extends AppenderSkeleton {
    private int bufferSize = 512;
    protected CyclicBuffer buffer = new CyclicBuffer(this.bufferSize);
    private boolean locationInfo = false;
    protected TriggeringEventEvaluator triggerEvaluator;
    private boolean addInfo;

    public SnapshotAppender() {
        this(new DefaultEvaluator());
    }

    public SnapshotAppender(TriggeringEventEvaluator evaluator) {
        this.triggerEvaluator = evaluator;
    }

    public void append(LoggingEvent event) {
        if (this.shouldAppend()) {
            event.getThreadName();
            event.getNDC();
            if (this.locationInfo) {
                event.getLocationInformation();
            }
            this.buffer.add(event);
            if (this.triggerEvaluator.isTriggeringEvent(event)) {
                this.writeSnapshot(this.buffer);
            }
        }
    }

    public void forceSnapshot() {
        this.writeSnapshot(this.buffer);
    }

    private void writeSnapshot(CyclicBuffer buffer) {
        StringBuffer details = new StringBuffer();
        String header = this.layout.getHeader();
        if (header != null) {
            details.append(header);
        }
        if (this.addInfo) {
            String user = System.getProperty("user.name");
            String system = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") " + System.getProperty("os.version");
            String java = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
            String version = this.getFrameworkVersion();
            LoggingEvent infoEvent = new LoggingEvent("", (Category)Logger.getRootLogger(), (Priority)Level.INFO, (Object)("Snapshot:- " + new Date() + "\n\t" + user + "\n\t" + system + "\n\t" + java + "\n\t" + version), null);
            details.append(this.layout.format(infoEvent));
        }
        int len = buffer.length();
        String message = "";
        for (int i = 0; i < len; ++i) {
            String[] s;
            LoggingEvent event = buffer.get();
            message = event.getLoggerName() + ": " + event.getMessage();
            details.append(this.layout.format(event));
            if (!this.layout.ignoresThrowable() || (s = event.getThrowableStrRep()) == null) continue;
            for (String element : s) {
                details.append(element);
                details.append('\n');
            }
        }
        String footer = this.layout.getFooter();
        if (footer != null) {
            details.append(footer);
        }
        this.writeSnapshot(message, details.toString());
    }

    private String getFrameworkVersion() {
        return "${project.version}-r${buildNumber}";
    }

    protected abstract void writeSnapshot(String var1, String var2);

    public synchronized void close() {
        this.closed = true;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getEvaluatorClass() {
        return this.triggerEvaluator == null ? null : this.triggerEvaluator.getClass().getName();
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffer.resize(bufferSize);
    }

    public void setEvaluatorClass(String value) {
        this.triggerEvaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName((String)value, TriggeringEventEvaluator.class, (Object)this.triggerEvaluator);
    }

    public void setAddInfo(boolean addInfo) {
        this.addInfo = addInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    protected boolean shouldAppend() {
        if (this.triggerEvaluator == null) {
            this.errorHandler.error("No TriggeringEventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "].");
            return false;
        }
        return true;
    }
}

