/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutable;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;
import org.junit.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMetricMutables {
    private final double EPSILON = 1.0E-42;

    @Test
    public void testSnapshot() {
        MetricsRecordBuilder mb = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        MetricMutableStat stat = new MetricMutableStat("s1", "stat", "ops", "time", true);
        stat.add(0L);
        MetricMutableStat stat2 = new MetricMutableStat("s2", "stat", "ops", "time");
        stat2.add(0L);
        List<MetricMutable> metrics = Arrays.asList(new MetricMutableCounterInt("c1", "int counter", 1), new MetricMutableCounterLong("c2", "long counter", 2L), new MetricMutableGaugeInt("g1", "int gauge", 3), new MetricMutableGaugeLong("g2", "long gauge", 4L), stat, stat2);
        for (MetricMutable metric : metrics) {
            metric.snapshot(mb, true);
        }
        stat2.snapshot(mb, true);
        stat2.add(1L);
        stat2.snapshot(mb, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter("c1", "int counter", 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter("c2", "long counter", 2L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge("g1", "int gauge", 3);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge("g2", "long gauge", 4L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter("s1_num_ops", "Number of ops for stat", 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((String)Mockito.eq((Object)"s1_avg_time"), (String)Mockito.eq((Object)"Average time for stat"), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((String)Mockito.eq((Object)"s1_stdev_time"), (String)Mockito.eq((Object)"Standard deviation of time for stat"), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((String)Mockito.eq((Object)"s1_imin_time"), (String)Mockito.eq((Object)"Interval min time for stat"), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((String)Mockito.eq((Object)"s1_imax_time"), (String)Mockito.eq((Object)"Interval max time for stat"), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((String)Mockito.eq((Object)"s1_min_time"), (String)Mockito.eq((Object)"Min time for stat"), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((String)Mockito.eq((Object)"s1_max_time"), (String)Mockito.eq((Object)"Max time for stat"), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addCounter("s2_num_ops", "Number of ops for stat", 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addGauge((String)Mockito.eq((Object)"s2_avg_time"), (String)Mockito.eq((Object)"Average time for stat"), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter("s2_num_ops", "Number of ops for stat", 2L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((String)Mockito.eq((Object)"s2_avg_time"), (String)Mockito.eq((Object)"Average time for stat"), AdditionalMatchers.eq((double)1.0, (double)1.0E-42));
    }
}

