/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;

public class TestEditLog
extends TestCase {
    static final int numDatanodes = 1;
    int numberTransactions = 100;
    int numThreads = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditLog() throws IOException {
        int i;
        Collection<File> namedirs = null;
        Collection<File> editsdirs = null;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(0, conf, 1, true, true, null, null);
        cluster.waitActive();
        FileSystem fileSys = cluster.getFileSystem();
        int numdirs = 0;
        try {
            namedirs = cluster.getNameDirs();
            editsdirs = cluster.getNameEditsDirs();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        for (File dir : namedirs) {
            System.out.println(dir);
            ++numdirs;
        }
        FSImage fsimage = new FSImage(namedirs, editsdirs);
        FSEditLog editLog = fsimage.getEditLog();
        FSEditLog.setBufferCapacity((int)2048);
        editLog.close();
        editLog.open();
        Thread[] threadId = new Thread[this.numThreads];
        for (i = 0; i < this.numThreads; ++i) {
            Transactions trans = new Transactions(editLog, this.numberTransactions);
            threadId[i] = new Thread((Runnable)trans, "TransactionThread-" + i);
            threadId[i].start();
        }
        for (i = 0; i < this.numThreads; ++i) {
            try {
                threadId[i].join();
                continue;
            }
            catch (InterruptedException e) {
                --i;
            }
        }
        editLog.close();
        Iterator it = fsimage.dirIterator((Storage.StorageDirType)FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            File editFile = FSImage.getImageFile((Storage.StorageDirectory)((Storage.StorageDirectory)it.next()), (FSImage.NameNodeFile)FSImage.NameNodeFile.EDITS);
            System.out.println("Verifying file: " + editFile);
            int numEdits = FSEditLog.loadFSEdits((EditLogInputStream)new FSEditLog.EditLogFileInputStream(editFile));
            int numLeases = FSNamesystem.getFSNamesystem().leaseManager.countLease();
            System.out.println("Number of outstanding leases " + numLeases);
            TestEditLog.assertEquals((int)0, (int)numLeases);
            TestEditLog.assertTrue((String)("Verification for " + editFile + " failed. " + "Expected " + this.numThreads * 2 * this.numberTransactions + " transactions. " + "Found " + numEdits + " transactions."), (numEdits == this.numThreads * 2 * this.numberTransactions ? 1 : 0) != 0);
        }
    }

    public void test203LayoutVersion() {
        for (int lv : Storage.LAYOUT_VERSIONS_203) {
            TestEditLog.assertTrue((boolean)Storage.is203LayoutVersion((int)lv));
        }
    }

    static class Transactions
    implements Runnable {
        FSEditLog editLog;
        int numTransactions;
        short replication = (short)3;
        long blockSize = 64L;

        Transactions(FSEditLog editlog, int num) {
            this.editLog = editlog;
            this.numTransactions = num;
        }

        @Override
        public void run() {
            PermissionStatus p = FSNamesystem.getFSNamesystem().createFsOwnerPermissions(new FsPermission(511));
            for (int i = 0; i < this.numTransactions; ++i) {
                try {
                    INodeFileUnderConstruction inode = new INodeFileUnderConstruction(p, this.replication, this.blockSize, 0L, "", "", null);
                    this.editLog.logOpenFile("/filename" + i, inode);
                    this.editLog.logCloseFile("/filename" + i, (INodeFile)inode);
                    this.editLog.logSync();
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Transaction " + i + " encountered exception " + e);
                }
            }
        }
    }
}

