/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.kfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.kfs.IFSImpl;

public class KFSEmulationImpl
implements IFSImpl {
    FileSystem localFS;

    public KFSEmulationImpl(Configuration conf) throws IOException {
        this.localFS = FileSystem.getLocal((Configuration)conf);
    }

    public boolean exists(String path) throws IOException {
        return this.localFS.exists(new Path(path));
    }

    public boolean isDirectory(String path) throws IOException {
        return this.localFS.isDirectory(new Path(path));
    }

    public boolean isFile(String path) throws IOException {
        return this.localFS.isFile(new Path(path));
    }

    public String[] readdir(String path) throws IOException {
        FileStatus[] p = this.localFS.listStatus(new Path(path));
        String[] entries = null;
        if (p == null) {
            return null;
        }
        entries = new String[p.length];
        for (int i = 0; i < p.length; ++i) {
            entries[i] = p[i].getPath().toString();
        }
        return entries;
    }

    public FileStatus[] readdirplus(Path path) throws IOException {
        return this.localFS.listStatus(path);
    }

    public int mkdirs(String path) throws IOException {
        if (this.localFS.mkdirs(new Path(path))) {
            return 0;
        }
        return -1;
    }

    public int rename(String source, String dest) throws IOException {
        if (this.localFS.rename(new Path(source), new Path(dest))) {
            return 0;
        }
        return -1;
    }

    public int rmdir(String path) throws IOException {
        String[] dirEntries;
        if (this.isDirectory(path) && (dirEntries = this.readdir(path)).length <= 2 && this.localFS.delete(new Path(path), true)) {
            return 0;
        }
        return -1;
    }

    public int remove(String path) throws IOException {
        if (this.isFile(path) && this.localFS.delete(new Path(path), true)) {
            return 0;
        }
        return -1;
    }

    public long filesize(String path) throws IOException {
        return this.localFS.getLength(new Path(path));
    }

    public short getReplication(String path) throws IOException {
        return 1;
    }

    public short setReplication(String path, short replication) throws IOException {
        return 1;
    }

    public String[][] getDataLocation(String path, long start, long len) throws IOException {
        BlockLocation[] blkLocations = this.localFS.getFileBlockLocations(this.localFS.getFileStatus(new Path(path)), start, len);
        if (blkLocations == null || blkLocations.length == 0) {
            return new String[0][];
        }
        int blkCount = blkLocations.length;
        String[][] hints = new String[blkCount][];
        for (int i = 0; i < blkCount; ++i) {
            String[] hosts = blkLocations[i].getHosts();
            hints[i] = new String[hosts.length];
            hints[i] = hosts;
        }
        return hints;
    }

    public long getModificationTime(String path) throws IOException {
        FileStatus s = this.localFS.getFileStatus(new Path(path));
        if (s == null) {
            return 0L;
        }
        return s.getModificationTime();
    }

    public FSDataOutputStream create(String path, short replication, int bufferSize) throws IOException {
        return this.localFS.create(new Path(path));
    }

    public FSDataInputStream open(String path, int bufferSize) throws IOException {
        return this.localFS.open(new Path(path));
    }
}

