/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ftpletcontainer.impl;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletContext;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.apache.ftpserver.ftpletcontainer.FtpletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFtpletContainer
implements FtpletContainer {
    private final Logger LOG = LoggerFactory.getLogger(DefaultFtpletContainer.class);
    private Map<String, Ftplet> ftplets = new ConcurrentHashMap<String, Ftplet>();

    public DefaultFtpletContainer() {
    }

    public DefaultFtpletContainer(Map<String, Ftplet> ftplets) {
        this.ftplets = ftplets;
    }

    @Override
    public synchronized Ftplet getFtplet(String name) {
        if (name == null) {
            return null;
        }
        return this.ftplets.get(name);
    }

    @Override
    public synchronized void init(FtpletContext ftpletContext) throws FtpException {
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            entry.getValue().init(ftpletContext);
        }
    }

    @Override
    public synchronized Map<String, Ftplet> getFtplets() {
        return this.ftplets;
    }

    @Override
    public void destroy() {
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            try {
                entry.getValue().destroy();
            }
            catch (Exception ex) {
                this.LOG.error(entry.getKey() + " :: FtpletHandler.destroy()", (Throwable)ex);
            }
        }
    }

    @Override
    public FtpletResult onConnect(FtpSession session) throws FtpException, IOException {
        FtpletResult retVal = FtpletResult.DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onConnect(session);
            if (retVal == null) {
                retVal = FtpletResult.DEFAULT;
            }
            if (retVal == FtpletResult.DEFAULT) continue;
            break;
        }
        return retVal;
    }

    @Override
    public FtpletResult onDisconnect(FtpSession session) throws FtpException, IOException {
        FtpletResult retVal = FtpletResult.DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onDisconnect(session);
            if (retVal == null) {
                retVal = FtpletResult.DEFAULT;
            }
            if (retVal == FtpletResult.DEFAULT) continue;
            break;
        }
        return retVal;
    }

    @Override
    public FtpletResult afterCommand(FtpSession session, FtpRequest request, FtpReply reply) throws FtpException, IOException {
        FtpletResult retVal = FtpletResult.DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().afterCommand(session, request, reply);
            if (retVal == null) {
                retVal = FtpletResult.DEFAULT;
            }
            if (retVal == FtpletResult.DEFAULT) continue;
            break;
        }
        return retVal;
    }

    @Override
    public FtpletResult beforeCommand(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletResult retVal = FtpletResult.DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().beforeCommand(session, request);
            if (retVal == null) {
                retVal = FtpletResult.DEFAULT;
            }
            if (retVal == FtpletResult.DEFAULT) continue;
            break;
        }
        return retVal;
    }
}

