/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseProperties
extends Properties {
    private static final long serialVersionUID = 5572645129592131953L;

    public BaseProperties() {
    }

    public BaseProperties(Properties prop) {
        super(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseProperties(File fl) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fl);
            this.load(fis);
        }
        catch (Throwable throwable) {
            IoUtils.close(fis);
            throw throwable;
        }
        IoUtils.close(fis);
    }

    public BaseProperties(InputStream is) throws IOException {
        this.load(is);
    }

    public boolean getBoolean(String str) throws FtpException {
        String prop = this.getProperty(str);
        if (prop == null) {
            throw new FtpException(str + " not found");
        }
        return prop.toLowerCase().equals("true");
    }

    public boolean getBoolean(String str, boolean bol) {
        try {
            return this.getBoolean(str);
        }
        catch (FtpException ex) {
            return bol;
        }
    }

    public int getInteger(String str) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new FtpException("BaseProperties.getInteger()", (Throwable)ex);
        }
    }

    public int getInteger(String str, int intVal) {
        try {
            return this.getInteger(str);
        }
        catch (FtpException ex) {
            return intVal;
        }
    }

    public long getLong(String str) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw new FtpException("BaseProperties.getLong()", (Throwable)ex);
        }
    }

    public long getLong(String str, long val) {
        try {
            return this.getLong(str);
        }
        catch (FtpException ex) {
            return val;
        }
    }

    public double getDouble(String str) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            throw new FtpException("BaseProperties.getDouble()", (Throwable)ex);
        }
    }

    public double getDouble(String str, double doubleVal) {
        try {
            return this.getDouble(str);
        }
        catch (FtpException ex) {
            return doubleVal;
        }
    }

    public InetAddress getInetAddress(String str) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException ex) {
            throw new FtpException("Host " + value + " not found");
        }
    }

    public InetAddress getInetAddress(String str, InetAddress addr) {
        try {
            return this.getInetAddress(str);
        }
        catch (FtpException ex) {
            return addr;
        }
    }

    public String getString(String str) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        return value;
    }

    public String getString(String str, String s) {
        try {
            return this.getString(str);
        }
        catch (FtpException ex) {
            return s;
        }
    }

    public File getFile(String str) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        return new File(value);
    }

    public File getFile(String str, File fl) {
        try {
            return this.getFile(str);
        }
        catch (FtpException ex) {
            return fl;
        }
    }

    public Class<?> getClass(String str) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        try {
            return Class.forName(value);
        }
        catch (ClassNotFoundException ex) {
            throw new FtpException("BaseProperties.getClass()", (Throwable)ex);
        }
    }

    public Class<?> getClass(String str, Class<?> cls) {
        try {
            return this.getClass(str);
        }
        catch (FtpException ex) {
            return cls;
        }
    }

    public TimeZone getTimeZone(String str) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        return TimeZone.getTimeZone(value);
    }

    public TimeZone getTimeZone(String str, TimeZone tz) {
        try {
            return this.getTimeZone(str);
        }
        catch (FtpException ex) {
            return tz;
        }
    }

    public SimpleDateFormat getDateFormat(String str) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        try {
            return new SimpleDateFormat(value);
        }
        catch (IllegalArgumentException e) {
            throw new FtpException("Date format was incorrect: " + value, (Throwable)e);
        }
    }

    public SimpleDateFormat getDateFormat(String str, SimpleDateFormat fmt) {
        try {
            return this.getDateFormat(str);
        }
        catch (FtpException ex) {
            return fmt;
        }
    }

    public Date getDate(String str, DateFormat fmt) throws FtpException {
        String value = this.getProperty(str);
        if (value == null) {
            throw new FtpException(str + " not found");
        }
        try {
            return fmt.parse(value);
        }
        catch (ParseException ex) {
            throw new FtpException("BaseProperties.getdate()", (Throwable)ex);
        }
    }

    public Date getDate(String str, DateFormat fmt, Date dt) {
        try {
            return this.getDate(str, fmt);
        }
        catch (FtpException ex) {
            return dt;
        }
    }

    public void setProperty(String key, boolean val) {
        this.setProperty(key, String.valueOf(val));
    }

    public void setProperty(String key, int val) {
        this.setProperty(key, String.valueOf(val));
    }

    public void setProperty(String key, double val) {
        this.setProperty(key, String.valueOf(val));
    }

    public void setProperty(String key, float val) {
        this.setProperty(key, String.valueOf(val));
    }

    public void setProperty(String key, long val) {
        this.setProperty(key, String.valueOf(val));
    }

    public void setInetAddress(String key, InetAddress val) {
        this.setProperty(key, val.getHostAddress());
    }

    public void setProperty(String key, File val) {
        this.setProperty(key, val.getAbsolutePath());
    }

    public void setProperty(String key, SimpleDateFormat val) {
        this.setProperty(key, val.toPattern());
    }

    public void setProperty(String key, TimeZone val) {
        this.setProperty(key, val.getID());
    }

    public void setProperty(String key, Date val, DateFormat fmt) {
        this.setProperty(key, fmt.format(val));
    }

    public void setProperty(String key, Class<?> val) {
        this.setProperty(key, val.getName());
    }
}

