/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.AbstractUserManager;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.ConcurrentLoginRequest;
import org.apache.ftpserver.usermanager.TransferRatePermission;
import org.apache.ftpserver.usermanager.TransferRateRequest;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.ftpserver.usermanager.WritePermission;
import org.apache.ftpserver.usermanager.WriteRequest;
import org.apache.ftpserver.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUserManager
extends AbstractUserManager {
    private final Logger LOG = LoggerFactory.getLogger(DbUserManager.class);
    private String insertUserStmt;
    private String updateUserStmt;
    private String deleteUserStmt;
    private String selectUserStmt;
    private String selectAllStmt;
    private String isAdminStmt;
    private String authenticateStmt;
    private DataSource dataSource;
    private Connection cachedConnection;
    private boolean configured = false;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getSqlUserInsert() {
        return this.insertUserStmt;
    }

    public void setSqlUserInsert(String sql) {
        this.insertUserStmt = sql;
    }

    public String getSqlUserDelete() {
        return this.deleteUserStmt;
    }

    public void setSqlUserDelete(String sql) {
        this.deleteUserStmt = sql;
    }

    public String getSqlUserUpdate() {
        return this.updateUserStmt;
    }

    public void setSqlUserUpdate(String sql) {
        this.updateUserStmt = sql;
    }

    public String getSqlUserSelect() {
        return this.selectUserStmt;
    }

    public void setSqlUserSelect(String sql) {
        this.selectUserStmt = sql;
    }

    public String getSqlUserSelectAll() {
        return this.selectAllStmt;
    }

    public void setSqlUserSelectAll(String sql) {
        this.selectAllStmt = sql;
    }

    public String getSqlUserAuthenticate() {
        return this.authenticateStmt;
    }

    public void setSqlUserAuthenticate(String sql) {
        this.authenticateStmt = sql;
    }

    public String getSqlUserAdmin() {
        return this.isAdminStmt;
    }

    public void setSqlUserAdmin(String sql) {
        this.isAdminStmt = sql;
    }

    private void lazyInit() {
        if (!this.configured) {
            this.configure();
        }
    }

    public void configure() {
        this.configured = true;
        if (this.dataSource == null) {
            throw new FtpServerConfigurationException("Required data source not provided");
        }
        if (this.insertUserStmt == null) {
            throw new FtpServerConfigurationException("Required insert user SQL statement not provided");
        }
        if (this.updateUserStmt == null) {
            throw new FtpServerConfigurationException("Required update user SQL statement not provided");
        }
        if (this.deleteUserStmt == null) {
            throw new FtpServerConfigurationException("Required delete user SQL statement not provided");
        }
        if (this.selectUserStmt == null) {
            throw new FtpServerConfigurationException("Required select user SQL statement not provided");
        }
        if (this.selectAllStmt == null) {
            throw new FtpServerConfigurationException("Required select all users SQL statement not provided");
        }
        if (this.isAdminStmt == null) {
            throw new FtpServerConfigurationException("Required is admin user SQL statement not provided");
        }
        if (this.authenticateStmt == null) {
            throw new FtpServerConfigurationException("Required authenticate user SQL statement not provided");
        }
        try {
            this.createConnection();
            this.LOG.info("Database connection opened.");
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.configure()", (Throwable)ex);
            throw new FtpServerConfigurationException("DbUserManager.configure()", ex);
        }
    }

    public boolean isAdmin(String login) throws FtpException {
        if (login == null) {
            return false;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userid", this.escapeString(login));
            String sql = StringUtils.replaceString(this.isAdminStmt, map);
            this.LOG.info(sql);
            stmt = this.createConnection().createStatement();
            rs = stmt.executeQuery(sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.isAdmin()", (Throwable)ex);
            throw new FtpException("DbUserManager.isAdmin()", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.isAdmin()", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.isAdmin()", (Throwable)ex);
                }
            }
        }
    }

    private synchronized Connection createConnection() throws SQLException {
        boolean isClosed = false;
        try {
            if (this.cachedConnection == null || this.cachedConnection.isClosed()) {
                isClosed = true;
            }
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.prepareConnection()", (Throwable)ex);
            isClosed = true;
        }
        if (isClosed) {
            this.closeConnection();
            this.cachedConnection = this.dataSource.getConnection();
            this.cachedConnection.setAutoCommit(true);
        }
        return this.cachedConnection;
    }

    private void closeConnection() {
        if (this.cachedConnection != null) {
            try {
                this.cachedConnection.close();
            }
            catch (SQLException ex) {
                this.LOG.error("DbUserManager.closeConnection()", (Throwable)ex);
            }
            this.cachedConnection = null;
        }
        this.LOG.info("Database connection closed.");
    }

    public synchronized void delete(String name) throws FtpException {
        this.lazyInit();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userid", this.escapeString(name));
        String sql = StringUtils.replaceString(this.deleteUserStmt, map);
        this.LOG.info(sql);
        Statement stmt = null;
        try {
            stmt = this.createConnection().createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.delete()", (Throwable)ex);
            throw new FtpException("DbUserManager.delete()", (Throwable)ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.delete()", (Throwable)ex);
                }
            }
        }
    }

    public synchronized void save(User user) throws FtpException {
        this.lazyInit();
        if (user.getName() == null) {
            throw new NullPointerException("User name is null.");
        }
        Statement stmt = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userid", this.escapeString(user.getName()));
            map.put("userpassword", this.escapeString(this.getPassword(user)));
            String home = user.getHomeDirectory();
            if (home == null) {
                home = "/";
            }
            map.put("homedirectory", this.escapeString(home));
            map.put("enableflag", String.valueOf(user.getEnabled()));
            map.put("writepermission", String.valueOf(user.authorize((AuthorizationRequest)new WriteRequest()) != null));
            map.put("idletime", user.getMaxIdleTime());
            TransferRateRequest transferRateRequest = new TransferRateRequest();
            transferRateRequest = (TransferRateRequest)user.authorize((AuthorizationRequest)transferRateRequest);
            if (transferRateRequest != null) {
                map.put("uploadrate", transferRateRequest.getMaxUploadRate());
                map.put("downloadrate", transferRateRequest.getMaxDownloadRate());
            } else {
                map.put("uploadrate", 0);
                map.put("downloadrate", 0);
            }
            ConcurrentLoginRequest concurrentLoginRequest = new ConcurrentLoginRequest(0, 0);
            concurrentLoginRequest = (ConcurrentLoginRequest)user.authorize((AuthorizationRequest)concurrentLoginRequest);
            if (concurrentLoginRequest != null) {
                map.put("maxloginnumber", concurrentLoginRequest.getMaxConcurrentLogins());
                map.put("maxloginperip", concurrentLoginRequest.getMaxConcurrentLoginsPerIP());
            } else {
                map.put("maxloginnumber", 0);
                map.put("maxloginperip", 0);
            }
            String sql = null;
            sql = !this.doesExist(user.getName()) ? StringUtils.replaceString(this.insertUserStmt, map) : StringUtils.replaceString(this.updateUserStmt, map);
            this.LOG.info(sql);
            stmt = this.createConnection().createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.save()", (Throwable)ex);
            throw new FtpException("DbUserManager.save()", (Throwable)ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUsermanager.error()", (Throwable)ex);
                }
            }
        }
    }

    public synchronized User getUserByName(String name) throws FtpException {
        this.lazyInit();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userid", this.escapeString(name));
            String sql = StringUtils.replaceString(this.selectUserStmt, map);
            this.LOG.info(sql);
            stmt = this.createConnection().createStatement();
            rs = stmt.executeQuery(sql);
            BaseUser thisUser = null;
            String trueStr = Boolean.TRUE.toString();
            if (rs.next()) {
                thisUser = new BaseUser();
                thisUser.setName(rs.getString("userid"));
                thisUser.setHomeDirectory(rs.getString("homedirectory"));
                thisUser.setEnabled(trueStr.equalsIgnoreCase(rs.getString("enableflag")));
                thisUser.setMaxIdleTime(rs.getInt("idletime"));
                ArrayList<Object> authorities = new ArrayList<Object>();
                if (trueStr.equalsIgnoreCase(rs.getString("writepermission"))) {
                    authorities.add(new WritePermission());
                }
                authorities.add(new ConcurrentLoginPermission(rs.getInt("maxloginnumber"), rs.getInt("maxloginperip")));
                authorities.add(new TransferRatePermission(rs.getInt("downloadrate"), rs.getInt("uploadrate")));
                thisUser.setAuthorities(authorities.toArray(new Authority[0]));
            }
            BaseUser baseUser = thisUser;
            return baseUser;
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.getUserByName()", (Throwable)ex);
            throw new FtpException("DbUserManager.getUserByName()", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.getUserByName()", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.getUserByName()", (Throwable)ex);
                }
            }
        }
    }

    public synchronized boolean doesExist(String name) throws FtpException {
        this.lazyInit();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userid", this.escapeString(name));
            String sql = StringUtils.replaceString(this.selectUserStmt, map);
            this.LOG.info(sql);
            stmt = this.createConnection().createStatement();
            rs = stmt.executeQuery(sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.doesExist()", (Throwable)ex);
            throw new FtpException("DbUserManager.doesExist()", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.doesExist()", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.doesExist()", (Throwable)ex);
                }
            }
        }
    }

    public synchronized String[] getAllUserNames() throws FtpException {
        this.lazyInit();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String sql = this.selectAllStmt;
            this.LOG.info(sql);
            stmt = this.createConnection().createStatement();
            rs = stmt.executeQuery(sql);
            ArrayList<String> names = new ArrayList<String>();
            while (rs.next()) {
                names.add(rs.getString("userid"));
            }
            String[] stringArray = names.toArray(new String[0]);
            return stringArray;
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.getAllUserNames()", (Throwable)ex);
            throw new FtpException("DbUserManager.getAllUserNames()", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.getAllUserNames()", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.getAllUserNames()", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getPassword(User user) throws SQLException {
        String password = user.getPassword();
        if (password != null) {
            return password;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userid", this.escapeString(user.getName()));
        String sql = StringUtils.replaceString(this.selectUserStmt, map);
        this.LOG.info(sql);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createConnection().createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                password = rs.getString("userpassword");
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.getPassword()", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    this.LOG.error("DbUserManager.getPassword()", (Throwable)ex);
                }
            }
        }
        if (password == null) {
            password = "";
        }
        return password;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized User authenticate(Authentication authentication) throws AuthenticationFailedException {
        this.lazyInit();
        if (authentication instanceof UsernamePasswordAuthentication) {
            UsernamePasswordAuthentication upauth = (UsernamePasswordAuthentication)authentication;
            String user = upauth.getUsername();
            String password = upauth.getPassword();
            if (user == null) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (password == null) {
                password = "";
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("userid", this.escapeString(user));
                map.put("userpassword", this.escapeString(password));
                String sql = StringUtils.replaceString(this.authenticateStmt, map);
                this.LOG.info(sql);
                stmt = this.createConnection().createStatement();
                rs = stmt.executeQuery(sql);
                if (!rs.next()) throw new AuthenticationFailedException("Authentication failed");
                try {
                    User user2 = this.getUserByName(user);
                    return user2;
                }
                catch (FtpException e) {
                    try {
                        throw new AuthenticationFailedException("Authentication failed", (Throwable)e);
                    }
                    catch (SQLException ex) {
                        this.LOG.error("DbUserManager.authenticate()", (Throwable)ex);
                        throw new AuthenticationFailedException("Authentication failed", (Throwable)ex);
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception ex) {
                        this.LOG.error("DbUserManager.authenticate()", (Throwable)ex);
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ex) {
                        this.LOG.error("DbUserManager.authenticate()", (Throwable)ex);
                    }
                }
            }
        }
        if (!(authentication instanceof AnonymousAuthentication)) throw new IllegalArgumentException("Authentication not supported by this user manager");
        try {
            if (!this.doesExist("anonymous")) throw new AuthenticationFailedException("Authentication failed");
            return this.getUserByName("anonymous");
        }
        catch (AuthenticationFailedException e) {
            throw e;
        }
        catch (FtpException e) {
            throw new AuthenticationFailedException("Authentication failed", (Throwable)e);
        }
    }

    public synchronized void dispose() {
        this.closeConnection();
    }

    private String escapeString(String input) {
        if (input == null) {
            return input;
        }
        StringBuffer valBuf = new StringBuffer(input);
        for (int i = 0; i < valBuf.length(); ++i) {
            char ch = valBuf.charAt(i);
            if (ch != '\'' && ch != '\\' && ch != '$' && ch != '^' && ch != '[' && ch != ']' && ch != '{' && ch != '}') continue;
            valBuf.insert(i, '\\');
            ++i;
        }
        return valBuf.toString();
    }
}

