/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.main;

import org.apache.ftpserver.FtpServer;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class CommandLine {
    private CommandLine() {
    }

    public static void main(String[] args) {
        try {
            FtpServer server = CommandLine.getConfiguration(args);
            if (server == null) {
                return;
            }
            server.start();
            System.out.println("FtpServer started");
            CommandLine.addShutdownHook(server);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void addShutdownHook(final FtpServer engine) {
        Runnable shutdownHook = new Runnable(){

            public void run() {
                System.out.println("Stopping server...");
                engine.stop();
            }
        };
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(shutdownHook));
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.ftpserver.main.CommandLine [OPTION] [CONFIGFILE]");
        System.err.println("Starts FtpServer using the default configuration of the ");
        System.err.println("configuration file if provided.");
        System.err.println("");
        System.err.println("      --default              use the default configuration, ");
        System.err.println("                             also used if no command line argument is given ");
        System.err.println("  -?, --help                 print this message");
    }

    private static FtpServer getConfiguration(String[] args) throws Exception {
        FtpServer server = null;
        if (args.length == 0) {
            System.out.println("Using default configuration");
            server = new FtpServer();
        } else if (args.length == 1 && args[0].equals("-default")) {
            System.out.println("The -default switch is deprecated, please use --default instead");
            System.out.println("Using default configuration");
            server = new FtpServer();
        } else if (args.length == 1 && args[0].equals("--default")) {
            System.out.println("Using default configuration");
            server = new FtpServer();
        } else if (args.length == 1 && args[0].equals("--help")) {
            CommandLine.usage();
        } else if (args.length == 1 && args[0].equals("-?")) {
            CommandLine.usage();
        } else if (args.length == 1) {
            System.out.println("Using XML configuration file " + args[0] + "...");
            XmlBeanFactory bf = new XmlBeanFactory((Resource)new FileSystemResource(args[0]));
            if (bf.containsBean("server")) {
                server = (FtpServer)bf.getBean("server");
            } else {
                String[] beanNames = bf.getBeanNamesForType(FtpServer.class);
                if (beanNames.length == 1) {
                    server = (FtpServer)bf.getBean(beanNames[0]);
                } else if (beanNames.length > 1) {
                    System.out.println("Using the first server defined in the configuration, named " + beanNames[0]);
                    server = (FtpServer)bf.getBean(beanNames[0]);
                } else {
                    System.err.println("XML configuration does not contain a server configuration");
                }
            }
        } else {
            CommandLine.usage();
        }
        return server;
    }
}

