/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ftplet;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletContext;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFtpletContainer
implements FtpletContainer {
    private final Logger LOG = LoggerFactory.getLogger(DefaultFtpletContainer.class);
    private Map<String, Ftplet> ftplets = new ConcurrentHashMap<String, Ftplet>();

    public void dispose() {
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            try {
                entry.getValue().destroy();
            }
            catch (Exception ex) {
                this.LOG.error(entry.getKey() + " :: FtpletHandler.destroy()", (Throwable)ex);
            }
        }
        this.ftplets.clear();
    }

    @Override
    public void addFtplet(String name, Ftplet ftplet) {
        if (this.getFtplet(name) != null) {
            throw new IllegalArgumentException("Ftplet with name \"" + name + "\" already registred with container");
        }
        this.ftplets.put(name, ftplet);
    }

    @Override
    public Ftplet removeFtplet(String name) {
        Ftplet ftplet = this.ftplets.get(name);
        if (ftplet != null) {
            this.ftplets.remove(name);
            return ftplet;
        }
        return null;
    }

    @Override
    public Ftplet getFtplet(String name) {
        if (name == null) {
            return null;
        }
        return this.ftplets.get(name);
    }

    public void destroy() {
        this.dispose();
    }

    public FtpletEnum onConnect(FtpSession session) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onConnect(session);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onDisconnect(FtpSession session) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onDisconnect(session);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onLogin(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onLogin(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onDeleteStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onDeleteStart(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onDeleteEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onDeleteEnd(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onUploadStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onUploadStart(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onUploadEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onUploadEnd(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onDownloadStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onDownloadStart(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onDownloadEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onDownloadEnd(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onRmdirStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onRmdirStart(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onRmdirEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onRmdirEnd(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onMkdirStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onMkdirStart(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onMkdirEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onMkdirEnd(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onAppendStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onAppendStart(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onAppendEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onAppendEnd(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onUploadUniqueStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onUploadUniqueStart(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onUploadUniqueEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onUploadUniqueEnd(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onRenameStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onRenameStart(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onRenameEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onRenameEnd(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public FtpletEnum onSite(FtpSession session, FtpRequest request) throws FtpException, IOException {
        FtpletEnum retVal = FtpletEnum.RET_DEFAULT;
        for (Map.Entry<String, Ftplet> entry : this.ftplets.entrySet()) {
            retVal = entry.getValue().onSite(session, request);
            if (retVal == null) {
                retVal = FtpletEnum.RET_DEFAULT;
            }
            if (retVal == FtpletEnum.RET_DEFAULT) continue;
            break;
        }
        return retVal;
    }

    public void init(FtpletContext ftpletContext) throws FtpException {
    }

    @Override
    public Map<String, Ftplet> getFtplets() {
        return this.ftplets;
    }

    @Override
    public void setFtplets(Map<String, Ftplet> ftplets) {
        this.ftplets = ftplets;
    }
}

