/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.config.spring;

import org.apache.ftpserver.config.spring.SpringUtil;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.usermanager.DbUserManager;
import org.apache.ftpserver.usermanager.PropertiesUserManager;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManagerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<? extends UserManager> getBeanClass(Element element) {
        if (element.getLocalName().equals("file-user-manager")) {
            return PropertiesUserManager.class;
        }
        return DbUserManager.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (this.getBeanClass(element) == PropertiesUserManager.class) {
            builder.addPropertyValue("propFile", (Object)element.getAttribute("file"));
            if (StringUtils.hasText((String)element.getAttribute("encrypt-passwords")) && element.getAttribute("encrypt-passwords").equals("true")) {
                builder.addPropertyValue("encryptPasswords", (Object)true);
            }
            builder.setInitMethodName("configure");
        } else {
            Element dsElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "data-source");
            Element springElm = SpringUtil.getChildElement(dsElm, null, null);
            Object o = "bean".equals(springElm.getLocalName()) ? parserContext.getDelegate().parseBeanDefinitionElement(springElm, (BeanDefinition)builder.getBeanDefinition()) : parserContext.getDelegate().parsePropertySubElement(springElm, (BeanDefinition)builder.getBeanDefinition());
            builder.addPropertyValue("dataSource", o);
            builder.addPropertyValue("sqlUserInsert", (Object)this.getSql(element, "insert-user"));
            builder.addPropertyValue("sqlUserUpdate", (Object)this.getSql(element, "update-user"));
            builder.addPropertyValue("sqlUserDelete", (Object)this.getSql(element, "delete-user"));
            builder.addPropertyValue("sqlUserSelect", (Object)this.getSql(element, "select-user"));
            builder.addPropertyValue("sqlUserSelectAll", (Object)this.getSql(element, "select-all-users"));
            builder.addPropertyValue("sqlUserAdmin", (Object)this.getSql(element, "is-admin"));
            builder.addPropertyValue("sqlUserAuthenticate", (Object)this.getSql(element, "authenticate"));
            builder.setInitMethodName("configure");
        }
    }

    private String getSql(Element element, String elmName) {
        return SpringUtil.getChildElementText(element, "http://mina.apache.org/ftpserver/spring/v1", elmName);
    }
}

