/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.config.spring;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.ftpserver.DefaultDataConnectionConfiguration;
import org.apache.ftpserver.config.spring.SpringUtil;
import org.apache.ftpserver.interfaces.DataConnectionConfiguration;
import org.apache.ftpserver.listener.nio.NioListener;
import org.apache.ftpserver.ssl.DefaultSslConfiguration;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.filter.firewall.Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private final Logger LOG = LoggerFactory.getLogger(ListenerBeanDefinitionParser.class);

    protected Class<NioListener> getBeanClass(Element element) {
        return NioListener.class;
    }

    private Subnet parseSubnet(String subnet) {
        InetAddress address;
        String maskString;
        String ipString;
        if (subnet == null) {
            throw new NullPointerException("subnet can not be null");
        }
        String[] tokens = subnet.split("/");
        if (tokens.length == 2) {
            ipString = tokens[0];
            maskString = tokens[1];
        } else if (tokens.length == 1) {
            ipString = tokens[0];
            maskString = "32";
        } else {
            throw new IllegalArgumentException("Illegal subnet format: " + subnet);
        }
        try {
            address = InetAddress.getByName(ipString);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Illegal IP address in subnet: " + subnet);
        }
        int mask = Integer.parseInt(maskString);
        if (mask < 0 || mask > 32) {
            throw new IllegalArgumentException("Mask must be in the range 0-32");
        }
        return new Subnet(address, mask);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        InetAddress localAddress;
        SslConfiguration ssl;
        if (StringUtils.hasText((String)element.getAttribute("port"))) {
            builder.addPropertyValue("port", (Object)Integer.parseInt(element.getAttribute("port")));
        }
        if ((ssl = this.parseSsl(element)) != null) {
            builder.addPropertyValue("sslConfiguration", (Object)ssl);
        }
        Element dataConElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "data-connection");
        DataConnectionConfiguration dc = this.parseDataConnection(dataConElm, ssl);
        builder.addPropertyValue("dataConnectionConfiguration", (Object)dc);
        Element blacklistElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "blacklist");
        if (blacklistElm != null && StringUtils.hasText((String)blacklistElm.getTextContent())) {
            String[] blocks = blacklistElm.getTextContent().split("[\\s,]+");
            ArrayList<Subnet> subnets = new ArrayList<Subnet>();
            for (String block : blocks) {
                subnets.add(this.parseSubnet(block));
            }
            builder.addPropertyValue("blockedSubnets", subnets);
        }
        if (StringUtils.hasText((String)element.getAttribute("idle-timeout"))) {
            builder.addPropertyValue("idleTimeout", (Object)SpringUtil.parseInt(element, "idle-timeout", 300));
        }
        if (StringUtils.hasText((String)element.getAttribute("port"))) {
            builder.addPropertyValue("port", (Object)SpringUtil.parseInt(element, "port", 21));
        }
        if ((localAddress = SpringUtil.parseInetAddress(element, "local-address")) != null) {
            builder.addPropertyValue("localAddress", (Object)localAddress);
        }
        builder.addPropertyValue("implicitSsl", (Object)SpringUtil.parseBoolean(element, "implicit-ssl", false));
    }

    private SslConfiguration parseSsl(Element parent) {
        Element sslElm = SpringUtil.getChildElement(parent, "http://mina.apache.org/ftpserver/spring/v1", "ssl");
        if (sslElm != null) {
            String protocol;
            String enabledCiphersuites;
            String clientAuthStr;
            Element trustStoreElm;
            DefaultSslConfiguration ssl = new DefaultSslConfiguration();
            Element keyStoreElm = SpringUtil.getChildElement(sslElm, "http://mina.apache.org/ftpserver/spring/v1", "keystore");
            if (keyStoreElm != null) {
                String algorithm;
                String keyPassword;
                String keyAlias;
                ssl.setKeystoreFile(SpringUtil.parseFile(keyStoreElm, "file"));
                ssl.setKeystorePassword(SpringUtil.parseString(keyStoreElm, "password"));
                String type = SpringUtil.parseString(keyStoreElm, "type");
                if (type != null) {
                    ssl.setKeystoreType(type);
                }
                if ((keyAlias = SpringUtil.parseString(keyStoreElm, "key-alias")) != null) {
                    ssl.setKeyAlias(keyAlias);
                }
                if ((keyPassword = SpringUtil.parseString(keyStoreElm, "key-password")) != null) {
                    ssl.setKeyPassword(keyPassword);
                }
                if ((algorithm = SpringUtil.parseString(keyStoreElm, "algorithm")) != null) {
                    ssl.setKeystoreAlgorithm(algorithm);
                }
            }
            if ((trustStoreElm = SpringUtil.getChildElement(sslElm, "http://mina.apache.org/ftpserver/spring/v1", "truststore")) != null) {
                String algorithm;
                ssl.setTruststoreFile(SpringUtil.parseFile(trustStoreElm, "file"));
                ssl.setTruststorePassword(SpringUtil.parseString(trustStoreElm, "password"));
                String type = SpringUtil.parseString(trustStoreElm, "type");
                if (type != null) {
                    ssl.setTruststoreType(type);
                }
                if ((algorithm = SpringUtil.parseString(trustStoreElm, "algorithm")) != null) {
                    ssl.setTruststoreAlgorithm(algorithm);
                }
            }
            if ((clientAuthStr = SpringUtil.parseString(sslElm, "client-authentication")) != null) {
                ssl.setClientAuthentication(clientAuthStr);
            }
            if ((enabledCiphersuites = SpringUtil.parseString(sslElm, "enabled-ciphersuites")) != null) {
                ssl.setEnabledCipherSuites(enabledCiphersuites.split(" "));
            }
            if ((protocol = SpringUtil.parseString(sslElm, "protocol")) != null) {
                ssl.setSslProtocol(protocol);
            }
            return ssl;
        }
        return null;
    }

    private DataConnectionConfiguration parseDataConnection(Element element, SslConfiguration listenerSslConfiguration) {
        DefaultDataConnectionConfiguration dc = new DefaultDataConnectionConfiguration();
        if (element != null) {
            Element passiveElm;
            SslConfiguration ssl = this.parseSsl(element);
            if (ssl != null) {
                this.LOG.debug("SSL configuration found for the data connection");
                dc.setSslConfiguration(ssl);
            } else if (listenerSslConfiguration != null) {
                this.LOG.debug("SSL configuration found for the listener, falling back for that for the data connection");
                dc.setSslConfiguration(listenerSslConfiguration);
            }
            Element activeElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "active");
            if (activeElm != null) {
                DefaultDataConnectionConfiguration.Active active = new DefaultDataConnectionConfiguration.Active();
                active.setEnable(SpringUtil.parseBoolean(activeElm, "enabled", true));
                active.setIpCheck(SpringUtil.parseBoolean(activeElm, "ip-check", false));
                active.setLocalPort(SpringUtil.parseInt(activeElm, "local-port", 0));
                InetAddress localAddress = SpringUtil.parseInetAddress(activeElm, "local-address");
                if (localAddress != null) {
                    active.setLocalAddress(localAddress);
                }
                dc.setActive(active);
            }
            if ((passiveElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "passive")) != null) {
                String ports;
                InetAddress externalAddress;
                DefaultDataConnectionConfiguration.Passive passive = new DefaultDataConnectionConfiguration.Passive();
                InetAddress address = SpringUtil.parseInetAddress(passiveElm, "address");
                if (address != null) {
                    passive.setAddress(address);
                }
                if ((externalAddress = SpringUtil.parseInetAddress(passiveElm, "external-address")) != null) {
                    passive.setExternalAddress(externalAddress);
                }
                if ((ports = SpringUtil.parseString(passiveElm, "ports")) != null) {
                    passive.setPorts(ports);
                }
                dc.setPassive(passive);
            }
        } else if (listenerSslConfiguration != null) {
            this.LOG.debug("SSL configuration found for the listener, falling back for that for the data connection");
            dc.setSslConfiguration(listenerSslConfiguration);
        }
        return dc;
    }
}

