/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.ConcurrentLoginRequest;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.logging.MdcInjectionFilter;

public class USER
extends AbstractCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        boolean success = false;
        ServerFtpStatistics stat = (ServerFtpStatistics)context.getFtpStatistics();
        try {
            session.resetState();
            String userName = request.getArgument();
            if (userName == null) {
                session.write(FtpReplyUtil.translate(session, request, context, 501, "USER", null));
                return;
            }
            MdcInjectionFilter.setProperty((IoSession)session, (String)"userName", (String)userName);
            BaseUser user = (BaseUser)session.getUser();
            if (session.isLoggedIn()) {
                if (userName.equals(user.getName())) {
                    session.write(FtpReplyUtil.translate(session, request, context, 230, "USER", null));
                    success = true;
                } else {
                    session.write(FtpReplyUtil.translate(session, request, context, 530, "USER.invalid", null));
                }
                return;
            }
            boolean anonymous = userName.equals("anonymous");
            if (anonymous && !context.getConnectionConfig().isAnonymousLoginEnabled()) {
                session.write(FtpReplyUtil.translate(session, request, context, 530, "USER.anonymous", null));
                return;
            }
            int currAnonLogin = stat.getCurrentAnonymousLoginNumber();
            int maxAnonLogin = context.getConnectionConfig().getMaxAnonymousLogins();
            if (anonymous && currAnonLogin >= maxAnonLogin) {
                session.write(FtpReplyUtil.translate(session, request, context, 421, "USER.anonymous", null));
                return;
            }
            int currLogin = stat.getCurrentLoginNumber();
            int maxLogin = context.getConnectionConfig().getMaxLogins();
            if (maxLogin != 0 && currLogin >= maxLogin) {
                session.write(FtpReplyUtil.translate(session, request, context, 421, "USER.login", null));
                return;
            }
            User configUser = context.getUserManager().getUserByName(userName);
            if (configUser != null) {
                ConcurrentLoginRequest loginRequest;
                InetAddress address = null;
                if (session.getRemoteAddress() instanceof InetSocketAddress) {
                    address = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
                }
                if (configUser.authorize((AuthorizationRequest)(loginRequest = new ConcurrentLoginRequest(stat.getCurrentUserLoginNumber(configUser) + 1, stat.getCurrentUserLoginNumber(configUser, address) + 1))) == null) {
                    session.write(FtpReplyUtil.translate(session, request, context, 421, "USER.login", null));
                    return;
                }
            }
            success = true;
            session.setUserArgument(userName);
            if (anonymous) {
                session.write(FtpReplyUtil.translate(session, request, context, 331, "USER.anonymous", userName));
            } else {
                session.write(FtpReplyUtil.translate(session, request, context, 331, "USER", userName));
            }
        }
        finally {
            if (!success) {
                session.closeOnFlush().awaitUninterruptibly(10000L);
            }
        }
    }
}

