/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.DefaultFtpReply;
import org.apache.ftpserver.IODataConnectionFactory;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STOR
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(STOR.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        block33: {
            try {
                DataConnection dataConnection;
                FtpletEnum ftpletRet;
                InetAddress address;
                long skipLen = session.getFileOffset();
                String fileName = request.getArgument();
                if (fileName == null) {
                    session.write(FtpReplyUtil.translate(session, request, context, 501, "STOR", null));
                    return;
                }
                ServerDataConnectionFactory connFactory = session.getDataConnection();
                if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                    session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                    return;
                }
                FtpletContainer ftpletContainer = context.getFtpletContainer();
                try {
                    ftpletRet = ftpletContainer.onUploadStart(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                    return;
                }
                FileObject file = null;
                try {
                    file = session.getFileSystemView().getFileObject(fileName);
                }
                catch (Exception ex) {
                    this.LOG.debug("Exception getting file object", (Throwable)ex);
                }
                if (file == null) {
                    session.write(FtpReplyUtil.translate(session, request, context, 550, "STOR.invalid", fileName));
                    return;
                }
                fileName = file.getFullName();
                if (!file.hasWritePermission()) {
                    session.write(FtpReplyUtil.translate(session, request, context, 550, "STOR.permission", fileName));
                    return;
                }
                session.write(FtpReplyUtil.translate(session, request, context, 150, "STOR", fileName)).awaitUninterruptibly(10000L);
                try {
                    dataConnection = session.getDataConnection().openConnection();
                }
                catch (Exception e) {
                    this.LOG.debug("Exception getting the input data stream", (Throwable)e);
                    session.write(FtpReplyUtil.translate(session, request, context, 425, "STOR", fileName));
                    session.resetState();
                    session.getDataConnection().closeDataConnection();
                    return;
                }
                boolean failure = false;
                OutputStream outStream = null;
                try {
                    outStream = file.createOutputStream(skipLen);
                    long transSz = dataConnection.transferFromClient(outStream);
                    String userName = session.getUser().getName();
                    this.LOG.info("File upload : " + userName + " - " + fileName);
                    ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                    ftpStat.setUpload(session, file, transSz);
                }
                catch (SocketException ex) {
                    this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                    failure = true;
                    session.write(FtpReplyUtil.translate(session, request, context, 426, "STOR", fileName));
                }
                catch (IOException ex) {
                    this.LOG.debug("IOException during data transfer", (Throwable)ex);
                    failure = true;
                    session.write(FtpReplyUtil.translate(session, request, context, 551, "STOR", fileName));
                }
                finally {
                    IoUtils.close(outStream);
                }
                if (failure) break block33;
                session.write(FtpReplyUtil.translate(session, request, context, 226, "STOR", fileName));
                try {
                    ftpletRet = ftpletContainer.onUploadEnd(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                    return;
                }
            }
            finally {
                session.resetState();
                session.getDataConnection().closeDataConnection();
            }
        }
    }
}

