/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.DataConnectionConfiguration;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IllegalInetAddressException;
import org.apache.ftpserver.util.IllegalPortException;
import org.apache.ftpserver.util.SocketAddressEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PORT
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(PORT.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException {
        InetSocketAddress address;
        session.resetState();
        if (!request.hasArgument()) {
            session.write(FtpReplyUtil.translate(session, request, context, 501, "PORT", null));
            return;
        }
        DataConnectionConfiguration dataCfg = session.getListener().getDataConnectionConfiguration();
        if (!dataCfg.isActiveEnabled()) {
            session.write(FtpReplyUtil.translate(session, request, context, 510, "PORT.disabled", null));
            return;
        }
        try {
            address = SocketAddressEncoder.decode(request.getArgument());
        }
        catch (IllegalInetAddressException e) {
            session.write(FtpReplyUtil.translate(session, request, context, 510, "PORT", null));
            return;
        }
        catch (IllegalPortException e) {
            this.LOG.debug("Invalid data port: " + request.getArgument(), (Throwable)e);
            session.write(FtpReplyUtil.translate(session, request, context, 552, "PORT.invalid", null));
            return;
        }
        catch (UnknownHostException e) {
            this.LOG.debug("Unknown host", (Throwable)e);
            session.write(FtpReplyUtil.translate(session, request, context, 553, "PORT.host", null));
            return;
        }
        if (dataCfg.isActiveIpCheck() && session.getRemoteAddress() instanceof InetSocketAddress) {
            InetAddress clientAddr = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
            if (!address.getAddress().equals(clientAddr)) {
                session.write(FtpReplyUtil.translate(session, request, context, 510, "PORT.mismatch", null));
                return;
            }
        }
        session.getDataConnection().initActiveDataConnection(address);
        session.write(FtpReplyUtil.translate(session, request, context, 200, "PORT", null));
    }
}

