/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.ftpserver.DataConnectionException;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.SocketAddressEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PASV
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(PASV.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        ServerDataConnectionFactory dataCon = session.getDataConnection();
        InetAddress externalPassiveAddress = session.getListener().getDataConnectionConfiguration().getPassiveExernalAddress();
        try {
            InetSocketAddress dataConAddress = dataCon.initPassiveDataConnection();
            InetAddress servAddr = externalPassiveAddress != null ? externalPassiveAddress : dataConAddress.getAddress();
            InetSocketAddress externalDataConAddress = new InetSocketAddress(servAddr, dataConAddress.getPort());
            String addrStr = SocketAddressEncoder.encode(externalDataConAddress);
            session.write(FtpReplyUtil.translate(session, request, context, 227, "PASV", addrStr));
        }
        catch (DataConnectionException e) {
            this.LOG.warn("Failed to open passive data connection", (Throwable)((Object)e));
            session.write(FtpReplyUtil.translate(session, request, context, 425, "PASV", null));
            return;
        }
    }
}

