/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CWD
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(CWD.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        String dirName = "/";
        if (request.hasArgument()) {
            dirName = request.getArgument();
        }
        FileSystemView fsview = session.getFileSystemView();
        boolean success = false;
        try {
            success = fsview.changeDirectory(dirName);
        }
        catch (Exception ex) {
            this.LOG.debug("Failed to change directory in file system", (Throwable)ex);
        }
        if (success) {
            dirName = fsview.getCurrentDirectory().getFullName();
            session.write(FtpReplyUtil.translate(session, request, context, 250, "CWD", dirName));
        } else {
            session.write(FtpReplyUtil.translate(session, request, context, 550, "CWD", null));
        }
    }
}

