/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.DefaultFtpReply;
import org.apache.ftpserver.IODataConnectionFactory;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APPE
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(APPE.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        block34: {
            try {
                DataConnection dataConnection;
                FtpletEnum ftpletRet;
                InetAddress address;
                session.resetState();
                String fileName = request.getArgument();
                if (fileName == null) {
                    session.write(FtpReplyUtil.translate(session, request, context, 501, "APPE", null));
                    return;
                }
                ServerDataConnectionFactory connFactory = session.getDataConnection();
                if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                    session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                    return;
                }
                FtpletContainer ftpletContainer = context.getFtpletContainer();
                try {
                    ftpletRet = ftpletContainer.onAppendStart(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                    return;
                }
                FileObject file = null;
                try {
                    file = session.getFileSystemView().getFileObject(fileName);
                }
                catch (Exception e) {
                    this.LOG.debug("File system threw exception", (Throwable)e);
                }
                if (file == null) {
                    session.write(FtpReplyUtil.translate(session, request, context, 550, "APPE.invalid", fileName));
                    return;
                }
                fileName = file.getFullName();
                if (file.doesExist() && !file.isFile()) {
                    session.write(FtpReplyUtil.translate(session, request, context, 550, "APPE.invalid", fileName));
                    return;
                }
                if (!file.hasWritePermission()) {
                    session.write(FtpReplyUtil.translate(session, request, context, 550, "APPE.permission", fileName));
                    return;
                }
                session.write(FtpReplyUtil.translate(session, request, context, 150, "APPE", fileName));
                try {
                    dataConnection = session.getDataConnection().openConnection();
                }
                catch (Exception e) {
                    this.LOG.debug("Exception when getting data input stream", (Throwable)e);
                    session.write(FtpReplyUtil.translate(session, request, context, 425, "APPE", fileName));
                    session.getDataConnection().closeDataConnection();
                    return;
                }
                boolean failure = false;
                OutputStream os = null;
                try {
                    long offset = 0L;
                    if (file.doesExist()) {
                        offset = file.getSize();
                    }
                    os = file.createOutputStream(offset);
                    long transSz = dataConnection.transferFromClient(os);
                    String userName = session.getUser().getName();
                    this.LOG.info("File upload : " + userName + " - " + fileName);
                    ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                    ftpStat.setUpload(session, file, transSz);
                }
                catch (SocketException e) {
                    this.LOG.debug("SocketException during file upload", (Throwable)e);
                    failure = true;
                    session.write(FtpReplyUtil.translate(session, request, context, 426, "APPE", fileName));
                    IoUtils.close(os);
                }
                catch (IOException e2) {
                    this.LOG.debug("IOException during file upload", (Throwable)e2);
                    failure = true;
                    session.write(FtpReplyUtil.translate(session, request, context, 551, "APPE", fileName));
                    {
                        catch (Throwable throwable) {
                            IoUtils.close(os);
                            throw throwable;
                        }
                    }
                    IoUtils.close(os);
                }
                IoUtils.close(os);
                if (failure) break block34;
                session.write(FtpReplyUtil.translate(session, request, context, 226, "APPE", fileName));
                try {
                    ftpletRet = ftpletContainer.onAppendEnd(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                    return;
                }
            }
            finally {
                session.getDataConnection().closeDataConnection();
            }
        }
    }
}

