/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.ftpserver.DataConnectionException;
import org.apache.ftpserver.IODataConnection;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.interfaces.DataConnectionConfiguration;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IODataConnectionFactory
implements ServerDataConnectionFactory {
    private final Logger LOG = LoggerFactory.getLogger(IODataConnectionFactory.class);
    private FtpServerContext serverContext;
    private Socket dataSoc;
    ServerSocket servSoc;
    InetAddress address;
    int port = 0;
    long requestTime = 0L;
    boolean passive = false;
    boolean secure = false;
    private boolean isZip = false;
    InetAddress serverControlAddress;
    FtpIoSession session;

    public IODataConnectionFactory(FtpServerContext serverContext, FtpIoSession session) {
        this.session = session;
        this.serverContext = serverContext;
    }

    public synchronized void closeDataConnection() {
        if (this.dataSoc != null) {
            try {
                this.dataSoc.close();
            }
            catch (Exception ex) {
                this.LOG.warn("FtpDataConnection.closeDataSocket()", (Throwable)ex);
            }
            this.dataSoc = null;
        }
        if (this.servSoc != null) {
            DataConnectionConfiguration dcc;
            try {
                this.servSoc.close();
            }
            catch (Exception ex) {
                this.LOG.warn("FtpDataConnection.closeDataSocket()", (Throwable)ex);
            }
            FtpServerContext ctx = this.serverContext;
            if (ctx != null && (dcc = this.session.getListener().getDataConnectionConfiguration()) != null) {
                dcc.releasePassivePort(this.port);
            }
            this.servSoc = null;
        }
        this.requestTime = 0L;
    }

    public synchronized void initActiveDataConnection(InetSocketAddress address) {
        this.closeDataConnection();
        this.passive = false;
        this.address = address.getAddress();
        this.port = address.getPort();
        this.requestTime = System.currentTimeMillis();
    }

    public synchronized InetSocketAddress initPassiveDataConnection() throws DataConnectionException {
        this.LOG.debug("Initiating passive data connection");
        this.closeDataConnection();
        int passivePort = this.session.getListener().getDataConnectionConfiguration().requestPassivePort();
        if (passivePort == -1) {
            this.servSoc = null;
            throw new DataConnectionException("Cannot find an available passive port.");
        }
        try {
            DataConnectionConfiguration dataCfg = this.session.getListener().getDataConnectionConfiguration();
            this.address = dataCfg.getPassiveAddress();
            if (this.address == null) {
                this.address = this.serverControlAddress;
            }
            if (this.secure) {
                this.LOG.debug("Opening SSL passive data connection on address \"{}\" and port {}", (Object)this.address, (Object)passivePort);
                SslConfiguration ssl = dataCfg.getSslConfiguration();
                if (ssl == null) {
                    throw new DataConnectionException("Data connection SSL required but not configured.");
                }
                this.servSoc = this.createServerSocket(ssl, this.address, passivePort);
                this.port = this.servSoc.getLocalPort();
                this.LOG.debug("SSL Passive data connection created on address \"{}\" and port {}", (Object)this.address, (Object)passivePort);
            } else {
                this.LOG.debug("Opening passive data connection on address \"{}\" and port {}", (Object)this.address, (Object)passivePort);
                this.servSoc = new ServerSocket(passivePort, 0, this.address);
                this.port = this.servSoc.getLocalPort();
                this.LOG.debug("Passive data connection created on address \"{}\" and port {}", (Object)this.address, (Object)passivePort);
            }
            this.servSoc.setSoTimeout(dataCfg.getIdleTime() * 1000);
            this.passive = true;
            this.requestTime = System.currentTimeMillis();
            return new InetSocketAddress(this.address, this.port);
        }
        catch (Exception ex) {
            this.servSoc = null;
            this.closeDataConnection();
            throw new DataConnectionException("Failed to initate passive data connection: " + ex.getMessage(), ex);
        }
    }

    private ServerSocket createServerSocket(SslConfiguration ssl, InetAddress address2, int passivePort) throws IOException, GeneralSecurityException {
        SSLContext ctx = ssl.getSSLContext();
        SSLServerSocketFactory ssocketFactory = ctx.getServerSocketFactory();
        SSLServerSocket sslServerSocket = null;
        sslServerSocket = address2 == null ? (SSLServerSocket)ssocketFactory.createServerSocket(passivePort, 100) : (SSLServerSocket)ssocketFactory.createServerSocket(passivePort, 100, address2);
        if (ssl.getClientAuth() == ClientAuth.NEED) {
            sslServerSocket.setNeedClientAuth(true);
        } else if (ssl.getClientAuth() == ClientAuth.WANT) {
            sslServerSocket.setWantClientAuth(true);
        }
        if (ssl.getEnabledCipherSuites() != null) {
            sslServerSocket.setEnabledCipherSuites(ssl.getEnabledCipherSuites());
        }
        return sslServerSocket;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public DataConnection openConnection() throws Exception {
        return new IODataConnection(this.createDataSocket(), this.session, this);
    }

    private synchronized Socket createDataSocket() throws Exception {
        this.dataSoc = null;
        DataConnectionConfiguration dataConfig = this.session.getListener().getDataConnectionConfiguration();
        try {
            if (!this.passive) {
                int localPort = dataConfig.getActiveLocalPort();
                if (this.secure) {
                    SslConfiguration ssl = dataConfig.getSslConfiguration();
                    if (ssl == null) {
                        throw new FtpException("Data connection SSL not configured");
                    }
                    if (localPort == 0) {
                        this.dataSoc = this.createSocket(ssl, this.address, this.port, null, localPort, false);
                    } else {
                        InetAddress localAddr = dataConfig.getActiveLocalAddress();
                        this.dataSoc = this.createSocket(ssl, this.address, this.port, localAddr, localPort, false);
                    }
                } else if (localPort == 0) {
                    this.dataSoc = new Socket(this.address, this.port);
                } else {
                    InetAddress localAddr = dataConfig.getActiveLocalAddress();
                    this.dataSoc = new Socket(this.address, this.port, localAddr, localPort);
                }
            } else {
                this.LOG.debug("Opening passive data connection");
                this.dataSoc = this.servSoc.accept();
                this.LOG.debug("Passive data connection opened");
            }
        }
        catch (Exception ex) {
            this.closeDataConnection();
            this.LOG.warn("FtpDataConnection.getDataSocket()", (Throwable)ex);
            throw ex;
        }
        if (this.dataSoc instanceof SSLSocket) {
            ((SSLSocket)this.dataSoc).startHandshake();
        }
        return this.dataSoc;
    }

    private Socket createSocket(SslConfiguration ssl, InetAddress address2, int port2, InetAddress localAddress, int localPort, boolean clientMode) throws IOException, GeneralSecurityException {
        SSLContext ctx = ssl.getSSLContext();
        SSLSocketFactory socFactory = ctx.getSocketFactory();
        SSLSocket ssoc = localPort != 0 ? (SSLSocket)socFactory.createSocket(address2, port2) : (SSLSocket)socFactory.createSocket(address2, port2, localAddress, localPort);
        ssoc.setUseClientMode(clientMode);
        if (ssl.getEnabledCipherSuites() != null) {
            ssoc.setEnabledCipherSuites(ssl.getEnabledCipherSuites());
        }
        return ssoc;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isZipMode() {
        return this.isZip;
    }

    public void setZipMode(boolean zip) {
        this.isZip = zip;
    }

    public synchronized boolean isTimeout(long currTime) {
        if (this.requestTime == 0L) {
            return false;
        }
        if (this.dataSoc != null) {
            return false;
        }
        int maxIdleTime = this.session.getListener().getDataConnectionConfiguration().getIdleTime() * 1000;
        if (maxIdleTime == 0) {
            return false;
        }
        return currTime - this.requestTime >= (long)maxIdleTime;
    }

    public void dispose() {
        this.closeDataConnection();
    }

    public void setServerControlAddress(InetAddress serverControlAddress) {
        this.serverControlAddress = serverControlAddress;
    }
}

