/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.util.Map;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.DefaultFtpServerContext;
import org.apache.ftpserver.ftplet.FileSystemManager;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.interfaces.CommandFactory;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.MessageResource;
import org.apache.ftpserver.listener.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpServer {
    private final Logger LOG = LoggerFactory.getLogger(FtpServer.class);
    private FtpServerContext serverContext;
    private boolean suspended;
    private boolean started = false;

    public FtpServer() throws Exception {
        this.serverContext = new DefaultFtpServerContext();
    }

    public FtpServer(FtpServerContext serverContext) throws Exception {
        this.serverContext = serverContext;
    }

    public void start() throws Exception {
        Map<String, Listener> listeners = this.serverContext.getListeners();
        for (Listener listener : listeners.values()) {
            listener.start(this.serverContext);
        }
        this.started = true;
        this.LOG.info("FTP server started");
    }

    public void stop() {
        if (!this.started || this.serverContext == null) {
            return;
        }
        Map<String, Listener> listeners = this.serverContext.getListeners();
        for (Listener listener : listeners.values()) {
            listener.stop();
        }
        if (this.serverContext != null) {
            this.serverContext.dispose();
            this.serverContext = null;
        }
        this.started = false;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public void suspend() {
        Map<String, Listener> listeners = this.serverContext.getListeners();
        for (Listener listener : listeners.values()) {
            listener.suspend();
        }
        this.suspended = true;
    }

    public void resume() {
        Map<String, Listener> listeners = this.serverContext.getListeners();
        for (Listener listener : listeners.values()) {
            listener.resume();
        }
        this.suspended = false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public FtpServerContext getServerContext() {
        return this.serverContext;
    }

    public void setServerContext(FtpServerContext serverContext) {
        this.serverContext = serverContext;
    }

    private DefaultFtpServerContext checkAndGetContext() {
        if (this.getServerContext() instanceof DefaultFtpServerContext) {
            return (DefaultFtpServerContext)this.getServerContext();
        }
        throw new IllegalStateException("Custom FtpServerContext provided, setters can not be used on FtpServer");
    }

    public Map<String, Listener> getListeners() {
        return this.getServerContext().getListeners();
    }

    public Listener getListener(String name) {
        return this.getServerContext().getListener(name);
    }

    public void addListener(String name, Listener listener) {
        this.checkAndGetContext().addListener(name, listener);
    }

    public void setListeners(Map<String, Listener> listeners) {
        this.checkAndGetContext().setListeners(listeners);
    }

    public Map<String, Ftplet> getFtplets() {
        return this.getServerContext().getFtpletContainer().getFtplets();
    }

    public void setFtplets(Map<String, Ftplet> ftplets) {
        this.getServerContext().getFtpletContainer().setFtplets(ftplets);
    }

    public UserManager getUserManager() {
        return this.getServerContext().getUserManager();
    }

    public void setUserManager(UserManager userManager) {
        this.checkAndGetContext().setUserManager(userManager);
    }

    public FileSystemManager getFileSystem() {
        return this.getServerContext().getFileSystemManager();
    }

    public void setFileSystem(FileSystemManager fileSystem) {
        this.checkAndGetContext().setFileSystemManager(fileSystem);
    }

    public CommandFactory getCommandFactory() {
        return this.getServerContext().getCommandFactory();
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.checkAndGetContext().setCommandFactory(commandFactory);
    }

    public MessageResource getMessageResource() {
        return this.getServerContext().getMessageResource();
    }

    public void setMessageResource(MessageResource messageResource) {
        this.checkAndGetContext().setMessageResource(messageResource);
    }

    public ConnectionConfig getConnectionConfig() {
        return this.getServerContext().getConnectionConfig();
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.checkAndGetContext().setConnectionConfig(connectionConfig);
    }
}

