/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.util.HashMap;
import java.util.Map;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.DefaultCommandFactory;
import org.apache.ftpserver.DefaultConnectionConfig;
import org.apache.ftpserver.FtpStatisticsImpl;
import org.apache.ftpserver.filesystem.NativeFileSystemManager;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.DefaultFtpletContainer;
import org.apache.ftpserver.ftplet.FileSystemManager;
import org.apache.ftpserver.ftplet.FtpStatistics;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.interfaces.CommandFactory;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.MessageResource;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.nio.NioListener;
import org.apache.ftpserver.message.MessageResourceImpl;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.PropertiesUserManager;
import org.apache.ftpserver.usermanager.TransferRatePermission;
import org.apache.ftpserver.usermanager.WritePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFtpServerContext
implements FtpServerContext {
    private final Logger LOG = LoggerFactory.getLogger(DefaultFtpServerContext.class);
    private MessageResource messageResource;
    private UserManager userManager;
    private FileSystemManager fileSystemManager;
    private FtpletContainer ftpletContainer;
    private FtpStatistics statistics;
    private CommandFactory commandFactory;
    private ConnectionConfig connectionConfig = new DefaultConnectionConfig();
    private Map<String, Listener> listeners = new HashMap<String, Listener>();
    private static final Authority[] ADMIN_AUTHORITIES = new Authority[]{new WritePermission()};
    private static final Authority[] ANON_AUTHORITIES = new Authority[]{new ConcurrentLoginPermission(20, 2), new TransferRatePermission(4800, 4800)};

    public DefaultFtpServerContext() throws Exception {
        this(true);
    }

    public DefaultFtpServerContext(boolean createDefaultUsers) throws Exception {
        try {
            this.createListeners();
            this.messageResource = new MessageResourceImpl();
            ((MessageResourceImpl)this.messageResource).configure();
            this.userManager = new PropertiesUserManager();
            ((PropertiesUserManager)this.userManager).configure();
            this.fileSystemManager = new NativeFileSystemManager();
            this.statistics = new FtpStatisticsImpl();
            this.commandFactory = new DefaultCommandFactory();
            if (createDefaultUsers) {
                this.createDefaultUsers();
            }
            this.ftpletContainer = new DefaultFtpletContainer();
        }
        catch (Exception ex) {
            this.dispose();
            throw ex;
        }
    }

    private void createListeners() throws Exception {
        this.listeners.put("default", new NioListener());
    }

    private void createDefaultUsers() throws Exception {
        String adminName;
        UserManager userManager = this.getUserManager();
        if (!userManager.doesExist(adminName = userManager.getAdminName())) {
            this.LOG.info("Creating user : " + adminName);
            BaseUser adminUser = new BaseUser();
            adminUser.setName(adminName);
            adminUser.setPassword(adminName);
            adminUser.setEnabled(true);
            adminUser.setAuthorities(ADMIN_AUTHORITIES);
            adminUser.setHomeDirectory("./res/home");
            adminUser.setMaxIdleTime(0);
            userManager.save((User)adminUser);
        }
        if (!userManager.doesExist("anonymous")) {
            this.LOG.info("Creating user : anonymous");
            BaseUser anonUser = new BaseUser();
            anonUser.setName("anonymous");
            anonUser.setPassword("");
            anonUser.setAuthorities(ANON_AUTHORITIES);
            anonUser.setEnabled(true);
            anonUser.setHomeDirectory("./res/home");
            anonUser.setMaxIdleTime(300);
            userManager.save((User)anonUser);
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    @Override
    public MessageResource getMessageResource() {
        return this.messageResource;
    }

    public FtpStatistics getFtpStatistics() {
        return this.statistics;
    }

    public void setFtpStatistics(FtpStatistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public FtpletContainer getFtpletContainer() {
        return this.ftpletContainer;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public Ftplet getFtplet(String name) {
        return this.ftpletContainer.getFtplet(name);
    }

    @Override
    public void dispose() {
        for (Listener listener : this.listeners.values()) {
            listener.stop();
        }
    }

    @Override
    public Listener getListener(String name) {
        return this.listeners.get(name);
    }

    public void setListener(String name, Listener listener) {
        this.listeners.put(name, listener);
    }

    @Override
    public Map<String, Listener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Map<String, Listener> listeners) {
        this.listeners = listeners;
    }

    public void addListener(String name, Listener listener) {
        this.listeners.put(name, listener);
    }

    public Listener removeListener(String name) {
        return this.listeners.remove(name);
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    public void setFtpletContainer(FtpletContainer ftpletContainer) {
        this.ftpletContainer = ftpletContainer;
    }

    public void setMessageResource(MessageResource messageResource) {
        this.messageResource = messageResource;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }
}

