/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.io.IOException;
import org.apache.ftpserver.FtpHandler;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.Command;
import org.apache.ftpserver.interfaces.CommandFactory;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.mina.core.session.IdleStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFtpHandler
implements FtpHandler {
    private final Logger LOG = LoggerFactory.getLogger(DefaultFtpHandler.class);
    private FtpServerContext context;
    private Listener listener;

    public void init(FtpServerContext context, Listener listener) {
        this.context = context;
        this.listener = listener;
    }

    public void sessionCreated(FtpIoSession session) throws Exception {
        session.setListener(this.listener);
    }

    public void sessionOpened(FtpIoSession session) throws Exception {
        this.context.getFtpletContainer().onConnect(session.getFtpletSession());
        session.write(FtpReplyUtil.translate(session, null, this.context, 220, null, null));
    }

    public void sessionClosed(FtpIoSession session) throws Exception {
        try {
            this.context.getFtpletContainer().onDisconnect(session.getFtpletSession());
        }
        catch (Exception e) {
            this.LOG.warn("Ftplet threw an exception on disconnect", (Throwable)e);
        }
        ServerFtpStatistics stats = (ServerFtpStatistics)this.context.getFtpStatistics();
        if (stats != null) {
            stats.setLogout(session);
        }
    }

    public void exceptionCaught(FtpIoSession session, Throwable cause) throws Exception {
        this.LOG.error("Exception caught, closing session", cause);
        session.closeOnFlush().awaitUninterruptibly(10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(FtpIoSession session, FtpRequest request) throws Exception {
        block9: {
            try {
                String commandName = request.getCommand();
                CommandFactory commandFactory = this.context.getCommandFactory();
                Command command = commandFactory.getCommand(commandName);
                if (command != null) {
                    FtpIoSession ftpIoSession = session;
                    synchronized (ftpIoSession) {
                        command.execute(session, this.context, request);
                        break block9;
                    }
                }
                session.write(FtpReplyUtil.translate(session, request, this.context, 502, "not.implemented", null));
            }
            catch (Exception ex) {
                try {
                    session.write(FtpReplyUtil.translate(session, request, this.context, 550, null, null));
                }
                catch (Exception ex1) {
                    // empty catch block
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                this.LOG.warn("RequestHandler.service()", (Throwable)ex);
            }
        }
    }

    public void sessionIdle(FtpIoSession session, IdleStatus status) throws Exception {
        this.LOG.info("Session idle, closing");
        session.closeOnFlush().awaitUninterruptibly(10000L);
    }

    public void messageSent(FtpIoSession session, FtpReply reply) throws Exception {
    }
}

