/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.util.HashMap;
import java.util.Map;
import org.apache.ftpserver.command.ABOR;
import org.apache.ftpserver.command.ACCT;
import org.apache.ftpserver.command.APPE;
import org.apache.ftpserver.command.AUTH;
import org.apache.ftpserver.command.CDUP;
import org.apache.ftpserver.command.CWD;
import org.apache.ftpserver.command.DELE;
import org.apache.ftpserver.command.EPRT;
import org.apache.ftpserver.command.EPSV;
import org.apache.ftpserver.command.FEAT;
import org.apache.ftpserver.command.HELP;
import org.apache.ftpserver.command.LANG;
import org.apache.ftpserver.command.LIST;
import org.apache.ftpserver.command.MD5;
import org.apache.ftpserver.command.MDTM;
import org.apache.ftpserver.command.MKD;
import org.apache.ftpserver.command.MLSD;
import org.apache.ftpserver.command.MLST;
import org.apache.ftpserver.command.MODE;
import org.apache.ftpserver.command.NLST;
import org.apache.ftpserver.command.NOOP;
import org.apache.ftpserver.command.OPTS;
import org.apache.ftpserver.command.PASS;
import org.apache.ftpserver.command.PASV;
import org.apache.ftpserver.command.PBSZ;
import org.apache.ftpserver.command.PORT;
import org.apache.ftpserver.command.PROT;
import org.apache.ftpserver.command.PWD;
import org.apache.ftpserver.command.QUIT;
import org.apache.ftpserver.command.REIN;
import org.apache.ftpserver.command.REST;
import org.apache.ftpserver.command.RETR;
import org.apache.ftpserver.command.RMD;
import org.apache.ftpserver.command.RNFR;
import org.apache.ftpserver.command.RNTO;
import org.apache.ftpserver.command.SITE;
import org.apache.ftpserver.command.SIZE;
import org.apache.ftpserver.command.STAT;
import org.apache.ftpserver.command.STOR;
import org.apache.ftpserver.command.STOU;
import org.apache.ftpserver.command.STRU;
import org.apache.ftpserver.command.SYST;
import org.apache.ftpserver.command.TYPE;
import org.apache.ftpserver.command.USER;
import org.apache.ftpserver.interfaces.Command;
import org.apache.ftpserver.interfaces.CommandFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommandFactory
implements CommandFactory {
    private static final HashMap<String, Command> DEFAULT_COMMAND_MAP = new HashMap();
    private Map<String, Command> commandMap = new HashMap<String, Command>();
    private boolean useDefaultCommands = true;

    public boolean isUseDefaultCommands() {
        return this.useDefaultCommands;
    }

    public void setUseDefaultCommands(boolean useDefaultCommands) {
        this.useDefaultCommands = useDefaultCommands;
    }

    public Map<String, Command> getCommandMap() {
        return this.commandMap;
    }

    public synchronized void setCommandMap(Map<String, Command> commandMap) {
        if (commandMap == null) {
            throw new NullPointerException("commandMap can not be null");
        }
        this.commandMap.clear();
        for (Map.Entry<String, Command> entry : commandMap.entrySet()) {
            this.commandMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
    }

    @Override
    public Command getCommand(String cmdName) {
        if (cmdName == null || cmdName.equals("")) {
            return null;
        }
        String upperCaseCmdName = cmdName.toUpperCase();
        Command command = this.commandMap.get(upperCaseCmdName);
        if (command == null && this.useDefaultCommands) {
            command = DEFAULT_COMMAND_MAP.get(upperCaseCmdName);
        }
        return command;
    }

    static {
        DEFAULT_COMMAND_MAP.put("ABOR", new ABOR());
        DEFAULT_COMMAND_MAP.put("ACCT", new ACCT());
        DEFAULT_COMMAND_MAP.put("APPE", new APPE());
        DEFAULT_COMMAND_MAP.put("AUTH", new AUTH());
        DEFAULT_COMMAND_MAP.put("CDUP", new CDUP());
        DEFAULT_COMMAND_MAP.put("CWD", new CWD());
        DEFAULT_COMMAND_MAP.put("DELE", new DELE());
        DEFAULT_COMMAND_MAP.put("EPRT", new EPRT());
        DEFAULT_COMMAND_MAP.put("EPSV", new EPSV());
        DEFAULT_COMMAND_MAP.put("FEAT", new FEAT());
        DEFAULT_COMMAND_MAP.put("HELP", new HELP());
        DEFAULT_COMMAND_MAP.put("LANG", new LANG());
        DEFAULT_COMMAND_MAP.put("LIST", new LIST());
        DEFAULT_COMMAND_MAP.put("MD5", new MD5());
        DEFAULT_COMMAND_MAP.put("MMD5", new MD5());
        DEFAULT_COMMAND_MAP.put("MDTM", new MDTM());
        DEFAULT_COMMAND_MAP.put("MLST", new MLST());
        DEFAULT_COMMAND_MAP.put("MKD", new MKD());
        DEFAULT_COMMAND_MAP.put("MLSD", new MLSD());
        DEFAULT_COMMAND_MAP.put("MODE", new MODE());
        DEFAULT_COMMAND_MAP.put("NLST", new NLST());
        DEFAULT_COMMAND_MAP.put("NOOP", new NOOP());
        DEFAULT_COMMAND_MAP.put("OPTS", new OPTS());
        DEFAULT_COMMAND_MAP.put("PASS", new PASS());
        DEFAULT_COMMAND_MAP.put("PASV", new PASV());
        DEFAULT_COMMAND_MAP.put("PBSZ", new PBSZ());
        DEFAULT_COMMAND_MAP.put("PORT", new PORT());
        DEFAULT_COMMAND_MAP.put("PROT", new PROT());
        DEFAULT_COMMAND_MAP.put("PWD", new PWD());
        DEFAULT_COMMAND_MAP.put("QUIT", new QUIT());
        DEFAULT_COMMAND_MAP.put("REIN", new REIN());
        DEFAULT_COMMAND_MAP.put("REST", new REST());
        DEFAULT_COMMAND_MAP.put("RETR", new RETR());
        DEFAULT_COMMAND_MAP.put("RMD", new RMD());
        DEFAULT_COMMAND_MAP.put("RNFR", new RNFR());
        DEFAULT_COMMAND_MAP.put("RNTO", new RNTO());
        DEFAULT_COMMAND_MAP.put("SITE", new SITE());
        DEFAULT_COMMAND_MAP.put("SIZE", new SIZE());
        DEFAULT_COMMAND_MAP.put("STAT", new STAT());
        DEFAULT_COMMAND_MAP.put("STOR", new STOR());
        DEFAULT_COMMAND_MAP.put("STOU", new STOU());
        DEFAULT_COMMAND_MAP.put("STRU", new STRU());
        DEFAULT_COMMAND_MAP.put("SYST", new SYST());
        DEFAULT_COMMAND_MAP.put("TYPE", new TYPE());
        DEFAULT_COMMAND_MAP.put("USER", new USER());
    }
}

