/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.etcd;

import com.google.protobuf.ByteString;
import io.etcd.jetcd.api.Event;
import io.etcd.jetcd.api.WatchCancelRequest;
import io.etcd.jetcd.api.WatchCreateRequest;
import io.etcd.jetcd.api.WatchGrpc;
import io.etcd.jetcd.api.WatchRequest;
import io.etcd.jetcd.api.WatchResponse;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.ConfigChangeEvent;
import org.apache.dubbo.configcenter.ConfigChangeType;
import org.apache.dubbo.configcenter.ConfigurationListener;
import org.apache.dubbo.configcenter.DynamicConfiguration;
import org.apache.dubbo.remoting.etcd.jetcd.JEtcdClient;

public class EtcdDynamicConfiguration
implements DynamicConfiguration {
    private String rootPath;
    private final JEtcdClient etcdClient;
    private final ConcurrentMap<ConfigurationListener, EtcdConfigWatcher> watchListenerMap;

    EtcdDynamicConfiguration(URL url) {
        this.rootPath = "/" + url.getParameter("config.namespace", "dubbo") + "/config";
        this.etcdClient = new JEtcdClient(url);
        this.etcdClient.addStateListener(state -> {
            if (state == 1) {
                try {
                    this.recover();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.watchListenerMap = new ConcurrentHashMap<ConfigurationListener, EtcdConfigWatcher>();
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        if (this.watchListenerMap.get(listener) == null) {
            String normalizedKey = this.convertKey(group, key);
            EtcdConfigWatcher watcher = new EtcdConfigWatcher(normalizedKey, listener);
            this.watchListenerMap.put(listener, watcher);
            watcher.watch();
        }
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        EtcdConfigWatcher watcher = (EtcdConfigWatcher)this.watchListenerMap.get(listener);
        watcher.cancelWatch();
    }

    @Override
    public String getRule(String key, String group, long timeout) throws IllegalStateException {
        return (String)this.getInternalProperty(this.convertKey(group, key));
    }

    @Override
    public String getProperties(String key, String group, long timeout) throws IllegalStateException {
        if (StringUtils.isEmpty(group)) {
            group = "dubbo";
        }
        return (String)this.getInternalProperty(this.convertKey(group, key));
    }

    @Override
    public Object getInternalProperty(String key) {
        return this.etcdClient.getKVValue(key);
    }

    private String convertKey(String group, String key) {
        return this.rootPath + "/" + group + "/" + key;
    }

    private void recover() {
        for (EtcdConfigWatcher watcher : this.watchListenerMap.values()) {
            watcher.watch();
        }
    }

    public class EtcdConfigWatcher
    implements StreamObserver<WatchResponse> {
        private ConfigurationListener listener;
        protected WatchGrpc.WatchStub watchStub;
        private StreamObserver<WatchRequest> observer;
        protected long watchId;
        private ManagedChannel channel;
        private String key;

        public EtcdConfigWatcher(String key, ConfigurationListener listener) {
            this.key = key;
            this.listener = listener;
            this.channel = EtcdDynamicConfiguration.this.etcdClient.getChannel();
        }

        public void onNext(WatchResponse watchResponse) {
            this.watchId = watchResponse.getWatchId();
            for (Event etcdEvent : watchResponse.getEventsList()) {
                ConfigChangeType type = ConfigChangeType.MODIFIED;
                if (etcdEvent.getType() == Event.EventType.DELETE) {
                    type = ConfigChangeType.DELETED;
                }
                ConfigChangeEvent event = new ConfigChangeEvent(etcdEvent.getKv().getKey().toString(StandardCharsets.UTF_8), etcdEvent.getKv().getValue().toString(StandardCharsets.UTF_8), type);
                this.listener.process(event);
            }
        }

        public void onError(Throwable throwable) {
        }

        public void onCompleted() {
        }

        public long getWatchId() {
            return this.watchId;
        }

        private void watch() {
            this.watchStub = WatchGrpc.newStub((Channel)this.channel);
            this.observer = this.watchStub.watch((StreamObserver)this);
            WatchCreateRequest.Builder builder = WatchCreateRequest.newBuilder().setKey(ByteString.copyFromUtf8((String)this.key)).setProgressNotify(true);
            WatchRequest req = WatchRequest.newBuilder().setCreateRequest(builder).build();
            this.observer.onNext((Object)req);
        }

        private void cancelWatch() {
            WatchCancelRequest watchCancelRequest = WatchCancelRequest.newBuilder().setWatchId(this.watchId).build();
            WatchRequest cancelRequest = WatchRequest.newBuilder().setCancelRequest(watchCancelRequest).build();
            this.observer.onNext((Object)cancelRequest);
        }
    }
}

