/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.Decorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.api.LdapEncoder;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.Referral;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapResultDecorator
implements LdapResult,
Decorator<LdapResult> {
    private final LdapResult decoratedLdapResult;
    private byte[] errorMessageBytes;
    private byte[] matchedDnBytes;
    private LdapApiService codec;

    public LdapResultDecorator(LdapResult decoratedLdapResult) {
        this.decoratedLdapResult = decoratedLdapResult;
    }

    public byte[] getErrorMessageBytes() {
        return this.errorMessageBytes;
    }

    public void setErrorMessageBytes(byte[] errorMessageBytes) {
        this.errorMessageBytes = errorMessageBytes;
    }

    public void setMatchedDnBytes(byte[] matchedDnBytes) {
        this.matchedDnBytes = matchedDnBytes;
    }

    public byte[] getMatchedDnBytes() {
        return this.matchedDnBytes;
    }

    public ResultCodeEnum getResultCode() {
        return this.decoratedLdapResult.getResultCode();
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.decoratedLdapResult.setResultCode(resultCode);
    }

    public Dn getMatchedDn() {
        return this.decoratedLdapResult.getMatchedDn();
    }

    public void setMatchedDn(Dn dn) {
        this.decoratedLdapResult.setMatchedDn(dn);
    }

    public String getDiagnosticMessage() {
        return this.decoratedLdapResult.getDiagnosticMessage();
    }

    public void setDiagnosticMessage(String diagnosticMessage) {
        this.decoratedLdapResult.setDiagnosticMessage(diagnosticMessage);
    }

    public boolean isReferral() {
        return this.decoratedLdapResult.isReferral();
    }

    public Referral getReferral() {
        return this.decoratedLdapResult.getReferral();
    }

    public void setReferral(Referral referral) {
        this.decoratedLdapResult.setReferral(referral);
    }

    public String toString() {
        return this.decoratedLdapResult.toString();
    }

    @Override
    public int computeLength() {
        int ldapResultLength = 0;
        ldapResultLength = 2 + Value.getNbBytes((int)this.getResultCode().getValue());
        if (this.getMatchedDn() == null) {
            ldapResultLength += 2;
        } else {
            byte[] matchedDNBytes = Strings.getBytesUtf8((String)Strings.trimLeft((String)this.getMatchedDn().getName()));
            ldapResultLength += 1 + TLV.getNbBytes((int)matchedDNBytes.length) + matchedDNBytes.length;
            this.setMatchedDnBytes(matchedDNBytes);
        }
        byte[] errorMessageBytes = Strings.getBytesUtf8((String)this.getDiagnosticMessage());
        ldapResultLength += 1 + TLV.getNbBytes((int)errorMessageBytes.length) + errorMessageBytes.length;
        this.setErrorMessageBytes(errorMessageBytes);
        int referralLength = LdapEncoder.computeReferralLength(this.getReferral());
        if (referralLength != 0) {
            ldapResultLength += 1 + TLV.getNbBytes((int)referralLength) + referralLength;
        }
        return ldapResultLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        try {
            Value.encodeEnumerated((ByteBuffer)buffer, (int)this.getResultCode().getValue());
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]));
        }
        Value.encode((ByteBuffer)buffer, (byte[])this.getMatchedDnBytes());
        Value.encode((ByteBuffer)buffer, (byte[])this.getErrorMessageBytes());
        Referral referral = this.getReferral();
        if (referral != null) {
            LdapEncoder.encodeReferral(buffer, referral);
        }
        return buffer;
    }

    @Override
    public LdapResult getDecorated() {
        return this.decoratedLdapResult;
    }

    @Override
    public LdapApiService getCodecService() {
        return this.codec;
    }
}

