/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteResponseDecorator
extends ResponseDecorator<DeleteResponse>
implements DeleteResponse {
    private int deleteResponseLength;

    public DeleteResponseDecorator(LdapApiService codec, DeleteResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setDeleteResponseLength(int deleteResponseLength) {
        this.deleteResponseLength = deleteResponseLength;
    }

    public int getDeleteResponseLength() {
        return this.deleteResponseLength;
    }

    @Override
    public int computeLength() {
        int deleteResponseLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        this.setDeleteResponseLength(deleteResponseLength);
        return 1 + TLV.getNbBytes((int)deleteResponseLength) + deleteResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)107);
            buffer.put(TLV.getBytes((int)this.getDeleteResponseLength()));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]));
        }
        return buffer;
    }
}

