/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.search.pagedSearch;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.search.pagedSearch.PagedResultsContainer;
import org.apache.directory.shared.ldap.codec.controls.search.pagedSearch.PagedResultsStates;
import org.apache.directory.shared.util.StringConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PagedResultsGrammar
extends AbstractGrammar<PagedResultsContainer> {
    static final Logger LOG = LoggerFactory.getLogger(PagedResultsGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<?> instance = new PagedResultsGrammar();

    private PagedResultsGrammar() {
        this.setName(PagedResultsGrammar.class.getName());
        this.transitions = new GrammarTransition[PagedResultsStates.LAST_PAGED_SEARCH_STATE.ordinal()][256];
        this.transitions[PagedResultsStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)PagedResultsStates.START_STATE, (Enum)PagedResultsStates.PAGED_SEARCH_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[PagedResultsStates.PAGED_SEARCH_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)PagedResultsStates.PAGED_SEARCH_SEQUENCE_STATE, (Enum)PagedResultsStates.SIZE_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<PagedResultsContainer>("Set PagedSearchControl size"){

            public void action(PagedResultsContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    int size = IntegerDecoder.parse((Value)value, (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
                    if (size < 0) {
                        size = Integer.MAX_VALUE;
                    }
                    if (IS_DEBUG) {
                        LOG.debug("size = " + size);
                    }
                    container.getDecorator().setSize(size);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04050, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[PagedResultsStates.SIZE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)PagedResultsStates.SIZE_STATE, (Enum)PagedResultsStates.COOKIE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<PagedResultsContainer>("Set PagedSearchControl cookie"){

            public void action(PagedResultsContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                if (container.getCurrentTLV().getLength() == 0) {
                    container.getDecorator().setCookie(StringConstants.EMPTY_BYTES);
                } else {
                    container.getDecorator().setCookie(value.getData());
                }
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

