/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchResultEntry;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAttributeType
extends GrammarAction<LdapMessageContainer<SearchResultEntryDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddAttributeType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddAttributeType() {
        super("Store the AttributeType");
    }

    public void action(LdapMessageContainer<SearchResultEntryDecorator> container) throws DecoderException {
        SearchResultEntryDecorator searchResultEntry = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        String type = "";
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04081, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        try {
            searchResultEntry.addAttribute(type);
        }
        catch (LdapException ine) {
            String msg = "The Attribute type " + type + "is invalid : " + ine.getMessage();
            LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
            throw new DecoderException(msg, (Throwable)ine);
        }
        if (IS_DEBUG) {
            LOG.debug("Attribute type : {}", (Object)type);
        }
    }
}

