/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreInitial
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreInitial.class);

    public StoreInitial() {
        super("Store an initial value");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        SubstringFilter substringFilter = (SubstringFilter)searchRequestDecorator.getTerminalFilter();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04108, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        substringFilter.setInitialSubstrings(Strings.utf8ToString((byte[])tlv.getValue().getData()));
        searchRequestDecorator.unstackFilters((Asn1Container)container);
    }
}

