/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.modifyDnRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.ModifyDnRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreModifyDnRequestNewSuperior
extends GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestNewSuperior.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreModifyDnRequestNewSuperior() {
        super("Store new superior");
    }

    public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Dn newSuperior = Dn.EMPTY_DN;
        if (tlv.getLength() == 0) {
            if (modifyDnRequest.getDeleteOldRdn()) {
                throw new DecoderException(I18n.err((I18n)I18n.ERR_04092, (Object[])new Object[0]));
            }
            LOG.warn("The new superior is null, so we will change the entry");
            modifyDnRequest.setNewSuperior(newSuperior);
        } else {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString((byte[])dnBytes);
            try {
                newSuperior = new Dn(new String[]{dnStr});
            }
            catch (LdapInvalidDnException ine) {
                String msg = "Invalid new superior Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
                throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), ine);
            }
            modifyDnRequest.setNewSuperior(newSuperior);
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("New superior Dn {}", (Object)newSuperior);
        }
    }
}

