/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.modifyDnRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.ModifyDnRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreModifyDnRequestEntryName
extends GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestEntryName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreModifyDnRequestEntryName() {
        super("Store ModifyDN request entry Name");
    }

    public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Dn entry = null;
        if (tlv.getLength() == 0) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04089, (Object[])new Object[0]));
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString((byte[])dnBytes);
        try {
            entry = new Dn(new String[]{dnStr});
        }
        catch (LdapInvalidDnException ine) {
            String msg = "Invalid Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
            LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
            ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
        }
        modifyDnRequest.setName(entry);
        if (IS_DEBUG) {
            LOG.debug("Modifying Dn {}", (Object)entry);
        }
    }
}

