/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.compareRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.CompareRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreCompareRequestEntryName
extends GrammarAction<LdapMessageContainer<CompareRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreCompareRequestEntryName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreCompareRequestEntryName() {
        super("Store CompareRequest entry Name");
    }

    public void action(LdapMessageContainer<CompareRequestDecorator> container) throws DecoderException {
        CompareRequest compareRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Dn entry = null;
        if (tlv.getLength() == 0) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04089, (Object[])new Object[0]));
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString((byte[])dnBytes);
        try {
            entry = new Dn(new String[]{dnStr});
        }
        catch (LdapInvalidDnException ine) {
            String msg = "Invalid Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
            LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
            CompareResponseImpl response = new CompareResponseImpl(compareRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
        }
        compareRequest.setName(entry);
        if (IS_DEBUG) {
            LOG.debug("Comparing Dn {}", (Object)entry);
        }
    }
}

