/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.addResponse;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.AddResponseDecorator;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.AddResponseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitAddResponse
extends GrammarAction<LdapMessageContainer<AddResponseDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAddResponse.class);

    public InitAddResponse() {
        super("Init AddResponse");
    }

    public void action(LdapMessageContainer<AddResponseDecorator> container) throws DecoderException {
        AddResponseDecorator addResponse = new AddResponseDecorator(container.getLdapCodecService(), (AddResponse)new AddResponseImpl(container.getMessageId()));
        container.setMessage(addResponse);
        TLV tlv = container.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04088, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        LOG.debug("Add Response");
    }
}

