/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.ldif;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.apache.directory.shared.ldap.model.ldif.LdifUtils;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifPartition
extends AbstractLdifPartition {
    private static Logger LOG = LoggerFactory.getLogger(LdifPartition.class);
    private File suffixDirectory;
    private static final boolean CREATE = Boolean.TRUE;
    private static final boolean DELETE = Boolean.FALSE;
    private FileFilter dirFilter = new FileFilter(){

        @Override
        public boolean accept(File dir) {
            return dir.isDirectory();
        }
    };
    private FileFilter entryFilter = new FileFilter(){

        @Override
        public boolean accept(File dir) {
            if (dir.getName().endsWith(".ldif")) {
                return dir.isFile();
            }
            return false;
        }
    };

    public LdifPartition(SchemaManager schemaManager) {
        super(schemaManager);
    }

    protected void doInit() throws Exception {
        if (!this.initialized) {
            File partitionDir = new File(this.getPartitionPath());
            if (this.suffixDn == null || this.suffixDn.isEmpty()) {
                String msg = I18n.err((I18n)I18n.ERR_150, (Object[])new Object[0]);
                LOG.error(msg);
                throw new LdapInvalidDnException(msg);
            }
            if (!this.suffixDn.isSchemaAware()) {
                this.suffixDn.apply(this.schemaManager);
            }
            String suffixDirName = this.getFileName(this.suffixDn);
            this.suffixDirectory = new File(partitionDir, suffixDirName);
            super.doInit();
            if (this.suffixDirectory.exists()) {
                this.loadEntries(partitionDir);
            } else {
                try {
                    this.suffixDirectory.mkdirs();
                }
                catch (SecurityException se) {
                    String msg = I18n.err((I18n)I18n.ERR_151, (Object[])new Object[]{this.suffixDirectory.getAbsolutePath(), se.getLocalizedMessage()});
                    LOG.error(msg);
                    throw se;
                }
                File contextEntryFile = new File(this.suffixDirectory + ".ldif");
                LOG.info("ldif file doesn't exist {}, creating it.", (Object)contextEntryFile.getAbsolutePath());
                if (contextEntryFile.exists()) {
                    LdifReader reader = new LdifReader(contextEntryFile);
                    DefaultEntry contextEntry = new DefaultEntry(this.schemaManager, reader.next().getEntry());
                    reader.close();
                    if (contextEntry.get("entryCSN") == null) {
                        contextEntry.add("entryCSN", new String[]{defaultCSNFactory.newInstance().toString()});
                    }
                    if (contextEntry.get("entryUUID") == null) {
                        String uuid = UUID.randomUUID().toString();
                        contextEntry.add("entryUUID", new String[]{uuid});
                    }
                    AddOperationContext addContext = new AddOperationContext(null, (Entry)contextEntry);
                    this.add(addContext);
                }
            }
        }
    }

    public void add(AddOperationContext addContext) throws LdapException {
        super.add(addContext);
        this.addEntry(addContext.getEntry());
    }

    public void delete(Long id) throws LdapException {
        Entry entry = this.lookup(id);
        super.delete((Comparable)id);
        if (entry != null) {
            File ldifFile = this.getFile(entry.getDn(), DELETE);
            boolean deleted = this.deleteFile(ldifFile);
            LOG.debug("deleted file {} {}", (Object)ldifFile.getAbsoluteFile(), (Object)deleted);
            File parentFile = ldifFile.getParentFile();
            if (parentFile.listFiles().length == 0) {
                this.deleteFile(parentFile);
                LOG.debug("deleted file {} {}", (Object)parentFile.getAbsoluteFile(), (Object)deleted);
            }
        }
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Long id = (Long)this.getEntryId(modifyContext.getDn());
        try {
            super.modify(modifyContext.getDn(), modifyContext.getModItems().toArray(new Modification[0]));
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), (Throwable)e);
        }
        Entry modifiedEntry = this.lookup(id);
        modifyContext.setAlteredEntry(modifiedEntry);
        Dn dn = modifyContext.getDn();
        try {
            FileWriter fw = new FileWriter(this.getFile(dn, DELETE));
            fw.write(LdifUtils.convertToLdif((Entry)modifiedEntry, (boolean)true));
            fw.close();
        }
        catch (IOException ioe) {
            throw new LdapOperationException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        Dn oldDn = moveContext.getDn();
        Long id = (Long)this.getEntryId(oldDn);
        super.move(moveContext);
        Entry modifiedEntry = this.lookup(id);
        this.entryMoved(oldDn, modifiedEntry, id);
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Dn oldDn = moveAndRenameContext.getDn();
        Long id = (Long)this.getEntryId(oldDn);
        super.moveAndRename(moveAndRenameContext);
        Entry modifiedEntry = this.lookup(id);
        moveAndRenameContext.setModifiedEntry(modifiedEntry);
        this.entryMoved(oldDn, modifiedEntry, id);
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        Dn oldDn = renameContext.getDn();
        Long id = (Long)this.getEntryId(oldDn);
        super.rename(renameContext);
        Entry modifiedEntry = this.lookup(id);
        renameContext.setModifiedEntry(modifiedEntry);
        this.entryMoved(oldDn, modifiedEntry, id);
    }

    private void entryMoved(Dn oldEntryDn, Entry modifiedEntry, Long entryIdOld) throws LdapException {
        this.addEntry(modifiedEntry);
        try {
            IndexCursor cursor = this.getSubLevelIndex().forwardCursor((Object)entryIdOld);
            while (cursor.next()) {
                IndexEntry entry = (IndexEntry)cursor.get();
                if (entry.getId() == entryIdOld) continue;
                this.addEntry(this.lookup((Comparable)entry.getId()));
            }
            cursor.close();
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), (Throwable)e);
        }
        File file = this.getFile(oldEntryDn, DELETE);
        boolean deleted = this.deleteFile(file);
        LOG.warn("move operation: deleted file {} {}", (Object)file.getAbsoluteFile(), (Object)deleted);
        String dirName = file.getAbsolutePath();
        dirName = dirName.substring(0, dirName.indexOf(".ldif"));
        deleted = this.deleteFile(new File(dirName));
        LOG.warn("move operation: deleted dir {} {}", (Object)dirName, (Object)deleted);
    }

    private void loadEntries(File entryDir) throws Exception {
        LOG.debug("Processing dir {}", (Object)entryDir.getName());
        File[] entries = entryDir.listFiles(this.entryFilter);
        if (entries != null && entries.length != 0) {
            LdifReader ldifReader = new LdifReader();
            for (File entry : entries) {
                LOG.debug("parsing ldif file {}", (Object)entry.getName());
                List ldifEntries = ldifReader.parseLdifFile(entry.getAbsolutePath());
                ldifReader.close();
                if (ldifEntries == null || ldifEntries.isEmpty()) continue;
                LdifEntry ldifEntry = (LdifEntry)ldifEntries.get(0);
                LOG.debug("Adding entry {}", (Object)ldifEntry);
                DefaultEntry serverEntry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
                if (!serverEntry.containsAttribute(new String[]{"entryCSN"})) {
                    serverEntry.put("entryCSN", new String[]{defaultCSNFactory.newInstance().toString()});
                }
                if (!serverEntry.containsAttribute(new String[]{"entryUUID"})) {
                    serverEntry.put("entryUUID", new String[]{UUID.randomUUID().toString()});
                }
                AddOperationContext addContext = new AddOperationContext(null, (Entry)serverEntry);
                super.add(addContext);
            }
        } else {
            return;
        }
        File[] dirs = entryDir.listFiles(this.dirFilter);
        if (dirs != null && dirs.length != 0) {
            for (File f : dirs) {
                this.loadEntries(f);
            }
        }
    }

    private File getFile(Dn entryDn, boolean create) throws LdapException {
        String parentDir = null;
        String rdnFileName = null;
        if (entryDn.equals((Object)this.suffixDn)) {
            parentDir = this.suffixDirectory.getParent() + File.separator;
            rdnFileName = this.suffixDn.getName() + ".ldif";
        } else {
            StringBuilder filePath = new StringBuilder();
            filePath.append(this.suffixDirectory).append(File.separator);
            Dn baseDn = entryDn.getDescendantOf(this.suffixDn);
            int size = baseDn.size();
            for (int i = 0; i < size - 1; ++i) {
                rdnFileName = this.getFileName(baseDn.getRdn(size - 1 - i));
                filePath.append(rdnFileName).append(File.separator);
            }
            rdnFileName = this.getFileName(entryDn.getRdn()) + ".ldif";
            parentDir = filePath.toString();
        }
        File dir = new File(parentDir);
        if (!dir.exists() && create && !dir.mkdir()) {
            throw new LdapException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{dir}));
        }
        File ldifFile = new File(parentDir + rdnFileName);
        if (ldifFile.exists() && create) {
            throw new LdapException(I18n.err((I18n)I18n.ERR_633, (Object[])new Object[0]));
        }
        return ldifFile;
    }

    private String getFileName(Rdn rdn) throws LdapException {
        StringBuilder fileName = new StringBuilder("");
        Iterator iterator = rdn.iterator();
        while (iterator.hasNext()) {
            Ava ava = (Ava)iterator.next();
            String normAT = ava.getNormType();
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(normAT);
            String atName = at.getName();
            String normValue = ava.getNormValue().getString();
            fileName.append(atName).append("=").append(normValue);
            if (!iterator.hasNext()) continue;
            fileName.append("+");
        }
        return this.getOSFileName(fileName.toString());
    }

    private String getFileName(Dn dn) throws LdapException {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Rdn rdn : dn.getRdns()) {
            String normAT = rdn.getNormType();
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(normAT);
            String atName = at.getName();
            String normValue = rdn.getNormValue().getString();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(atName).append("=").append(normValue);
        }
        return this.getOSFileName(sb.toString());
    }

    private String getOSFileName(String fileName) {
        StringBuilder sb = new StringBuilder();
        block3: for (char c : fileName.toCharArray()) {
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '|': 
                case '\u007f': {
                    sb.append("%").append(Strings.dumpHex((byte)((byte)(c >> 4)))).append(Strings.dumpHex((byte)((byte)(c & 0xF))));
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return Strings.toLowerCase((String)sb.toString());
    }

    private void addEntry(Entry entry) throws LdapException {
        try {
            FileWriter fw = new FileWriter(this.getFile(entry.getDn(), CREATE));
            fw.write(LdifUtils.convertToLdif((Entry)entry));
            fw.close();
        }
        catch (IOException ioe) {
            throw new LdapOperationException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    private boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.deleteFile(f);
            }
            return file.delete();
        }
        return file.delete();
    }
}

