/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.text.ParseException;
import java.util.Map;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntryModifier;
import org.apache.directory.server.kerberos.shared.store.operations.StoreUtils;
import org.apache.directory.server.protocol.shared.store.DirectoryServiceOperation;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.codec.types.PrincipalNameType;
import org.apache.directory.shared.kerberos.codec.types.SamType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.name.Dn;

public class GetPrincipal
implements DirectoryServiceOperation {
    private final KerberosPrincipal principal;

    public GetPrincipal(KerberosPrincipal principal) {
        this.principal = principal;
    }

    public Object execute(CoreSession session, Dn base) throws Exception {
        if (this.principal == null) {
            return null;
        }
        return this.getEntry(StoreUtils.findPrincipalEntry(session, base, this.principal.getName()));
    }

    private PrincipalStoreEntry getEntry(Entry entry) throws Exception {
        String val;
        PrincipalStoreEntryModifier modifier = new PrincipalStoreEntryModifier();
        modifier.setDistinguishedName(entry.getDn().getName());
        String principal = entry.get("krb5PrincipalName").getString();
        modifier.setPrincipal(new KerberosPrincipal(principal, PrincipalNameType.KRB_NT_PRINCIPAL.getValue()));
        String keyVersionNumber = entry.get("krb5KeyVersionNumber").getString();
        modifier.setKeyVersionNumber(Integer.parseInt(keyVersionNumber));
        if (entry.get("krb5AccountDisabled") != null) {
            val = entry.get("krb5AccountDisabled").getString();
            modifier.setDisabled("true".equalsIgnoreCase(val));
        }
        if (entry.get("krb5AccountLockedOut") != null) {
            val = entry.get("krb5AccountLockedOut").getString();
            modifier.setLockedOut("true".equalsIgnoreCase(val));
        }
        if (entry.get("krb5AccountExpirationTime") != null) {
            val = entry.get("krb5AccountExpirationTime").getString();
            try {
                modifier.setExpiration(KerberosTime.getTime(val));
            }
            catch (ParseException e) {
                throw new Exception("Account expiration attribute krb5AccountExpirationTime contained an invalid value for generalizedTime: " + val);
            }
        }
        if (entry.get("apacheSamType") != null) {
            String samType = entry.get("apacheSamType").getString();
            modifier.setSamType(SamType.getTypeByOrdinal(Integer.parseInt(samType)));
        }
        if (entry.get("krb5Key") != null) {
            Attribute krb5key = entry.get("krb5Key");
            try {
                Map<EncryptionType, EncryptionKey> keyMap = modifier.reconstituteKeyMap(krb5key);
                modifier.setKeyMap(keyMap);
            }
            catch (KerberosException ioe) {
                throw new Exception(I18n.err((I18n)I18n.ERR_623, (Object[])new Object[]{"krb5Key"}));
            }
        }
        return modifier.getEntry();
    }
}

