/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.List;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.api.normalization.FilterNormalizingVisitor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.FilterVisitor;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.apache.directory.shared.ldap.model.schema.normalizers.NameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizationInterceptor.class);
    private FilterNormalizingVisitor normVisitor;

    public NormalizationInterceptor() {
        super(InterceptorEnum.NORMALIZATION_INTERCEPTOR);
    }

    public void init(DirectoryService directoryService) throws LdapException {
        LOG.debug("Initialiazing the NormalizationInterceptor");
        super.init(directoryService);
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.schemaManager);
        this.normVisitor = new FilterNormalizingVisitor((NameComponentNormalizer)ncn, this.schemaManager);
    }

    public void destroy() {
    }

    public void add(AddOperationContext addContext) throws LdapException {
        addContext.getDn().apply(this.schemaManager);
        addContext.getEntry().getDn().apply(this.schemaManager);
        this.addRdnAttributesToEntry(addContext.getDn(), addContext.getEntry());
        this.next(addContext);
    }

    public void bind(BindOperationContext bindContext) throws LdapException {
        bindContext.getDn().apply(this.schemaManager);
        this.next(bindContext);
    }

    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        if (!compareContext.getDn().isSchemaAware()) {
            compareContext.getDn().apply(this.schemaManager);
        }
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(compareContext.getOid());
            if (attributeType.getSyntax().isHumanReadable() && !compareContext.getValue().isHumanReadable()) {
                String value = compareContext.getValue().getString();
                compareContext.setValue((Value)new StringValue(value));
            }
            compareContext.setAttributeType(attributeType);
        }
        catch (LdapException le) {
            throw new LdapInvalidAttributeTypeException(I18n.err((I18n)I18n.ERR_266, (Object[])new Object[]{compareContext.getOid()}));
        }
        return this.next(compareContext);
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        if (!dn.isSchemaAware()) {
            dn.apply(this.schemaManager);
        }
        this.next(deleteContext);
    }

    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        hasEntryContext.getDn().apply(this.schemaManager);
        return this.next(hasEntryContext);
    }

    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        listContext.getDn().apply(this.schemaManager);
        return this.next(listContext);
    }

    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        lookupContext.getDn().apply(this.schemaManager);
        List attrIds = lookupContext.getAttrsId();
        if (attrIds != null && attrIds.size() > 0) {
            lookupContext.setAttrsId(this.normalizeAttrsId(lookupContext.getAttrsIdArray()));
        }
        return this.next(lookupContext);
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (!modifyContext.getDn().isSchemaAware()) {
            modifyContext.getDn().apply(this.schemaManager);
        }
        if (modifyContext.getModItems() != null) {
            for (Modification modification : modifyContext.getModItems()) {
                AttributeType attributeType = this.schemaManager.getAttributeType(modification.getAttribute().getId());
                modification.apply(attributeType);
            }
        }
        this.next(modifyContext);
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        if (!moveContext.getDn().isSchemaAware()) {
            moveContext.getDn().apply(this.schemaManager);
        }
        if (!moveContext.getOldSuperior().isSchemaAware()) {
            moveContext.getOldSuperior().apply(this.schemaManager);
        }
        if (!moveContext.getNewSuperior().isSchemaAware()) {
            moveContext.getNewSuperior().apply(this.schemaManager);
        }
        if (!moveContext.getNewDn().isSchemaAware()) {
            moveContext.getNewDn().apply(this.schemaManager);
        }
        if (!moveContext.getRdn().isSchemaAware()) {
            moveContext.getRdn().apply(this.schemaManager);
        }
        this.next(moveContext);
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (!moveAndRenameContext.getNewRdn().isSchemaAware()) {
            moveAndRenameContext.getNewRdn().apply(this.schemaManager);
        }
        if (!moveAndRenameContext.getDn().isSchemaAware()) {
            moveAndRenameContext.getDn().apply(this.schemaManager);
        }
        if (!moveAndRenameContext.getNewDn().isSchemaAware()) {
            moveAndRenameContext.getNewDn().apply(this.schemaManager);
        }
        if (!moveAndRenameContext.getNewSuperiorDn().isSchemaAware()) {
            moveAndRenameContext.getNewSuperiorDn().apply(this.schemaManager);
        }
        this.next(moveAndRenameContext);
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        if (!renameContext.getDn().isSchemaAware()) {
            renameContext.getDn().apply(this.schemaManager);
        }
        renameContext.getNewRdn().apply(this.schemaManager);
        if (!renameContext.getNewDn().isSchemaAware()) {
            renameContext.getNewDn().apply(this.schemaManager);
        }
        this.next(renameContext);
    }

    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        ExprNode filter;
        Dn dn = searchContext.getDn();
        if (!dn.isSchemaAware()) {
            dn.apply(this.schemaManager);
        }
        if ((filter = searchContext.getFilter()) == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new BaseEntryFilteringCursor((Cursor)new EmptyCursor(), (SearchingOperationContext)searchContext);
        }
        if ((filter = (ExprNode)filter.accept((FilterVisitor)this.normVisitor)) == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new BaseEntryFilteringCursor((Cursor)new EmptyCursor(), (SearchingOperationContext)searchContext);
        }
        searchContext.setFilter(filter);
        return this.next(searchContext);
    }

    private String[] normalizeAttrsId(String[] attrIds) throws LdapException {
        if (attrIds == null) {
            return attrIds;
        }
        String[] normalizedAttrIds = new String[attrIds.length];
        int pos = 0;
        for (String id : attrIds) {
            String oid = this.schemaManager.lookupAttributeTypeRegistry(id).getOid();
            normalizedAttrIds[pos++] = oid;
        }
        return normalizedAttrIds;
    }

    private void addRdnAttributesToEntry(Dn dn, Entry entry) throws LdapException {
        if (dn == null || entry == null) {
            return;
        }
        Rdn rdn = dn.getRdn();
        for (Ava ava : rdn) {
            Value value = ava.getNormValue();
            Value upValue = ava.getValue();
            String upId = ava.getType();
            if (entry.contains(upId, new Value[]{value})) continue;
            String message = "The Rdn '" + upId + "=" + upValue + "' is not present in the entry";
            LOG.warn(message);
            if (!entry.containsAttribute(new String[]{upId})) {
                entry.add(upId, new Value[]{upValue});
                continue;
            }
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(upId);
            if (at.isSingleValued()) {
                entry.removeAttributes(new String[]{upId});
                entry.add(upId, new Value[]{upValue});
                continue;
            }
            entry.add(upId, new Value[]{upValue});
        }
    }
}

