/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.journal;

import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.journal.Journal;
import org.apache.directory.server.core.api.journal.JournalStore;
import org.apache.directory.server.core.journal.DefaultJournalStore;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJournal
implements Journal {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJournal.class);
    private boolean enabled;
    private JournalStore store;
    private int rotation;

    public void destroy() throws Exception {
        LOG.debug("Stopping the journal");
        if (this.store != null) {
            this.store.destroy();
        }
    }

    public JournalStore getJournalStore() {
        return this.store;
    }

    public void init(DirectoryService directoryService) throws Exception {
        LOG.debug("Starting the journal");
        if (this.store == null) {
            this.store = new DefaultJournalStore();
        }
        this.store.init(directoryService);
        LOG.debug("The Journal service has been initialized");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void log(LdapPrincipal principal, long revision, LdifEntry entry) throws LdapException {
        this.store.log(principal, revision, entry);
    }

    public void ack(long revision) {
        this.store.ack(revision);
    }

    public void nack(long revision) {
        this.store.nack(revision);
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setJournalStore(JournalStore store) {
        this.store = store;
    }
}

