/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.event.DirectoryListener;
import org.apache.directory.server.core.api.event.Evaluator;
import org.apache.directory.server.core.api.event.EventService;
import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.server.core.api.event.ExpressionEvaluator;
import org.apache.directory.server.core.api.event.NotificationCriteria;
import org.apache.directory.server.core.api.event.RegistrationEntry;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.event.DefaultEventService;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(EventInterceptor.class);
    private Evaluator evaluator;
    private ExecutorService executor;

    public EventInterceptor() {
        super(InterceptorEnum.EVENT_INTERCEPTOR);
    }

    public void init(DirectoryService directoryService) throws LdapException {
        LOG.info("Initializing ...");
        super.init(directoryService);
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.schemaManager);
        this.evaluator = new ExpressionEvaluator(this.schemaManager);
        this.executor = new ThreadPoolExecutor(1, 10, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100));
        this.directoryService.setEventService((EventService)new DefaultEventService(directoryService));
        LOG.info("Initialization complete.");
    }

    private void fire(final OperationContext opContext, EventType type, final DirectoryListener listener) {
        switch (type) {
            case ADD: {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.entryAdded((AddOperationContext)opContext);
                    }
                });
                break;
            }
            case DELETE: {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.entryDeleted((DeleteOperationContext)opContext);
                    }
                });
                break;
            }
            case MODIFY: {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.entryModified((ModifyOperationContext)opContext);
                    }
                });
                break;
            }
            case MOVE: {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.entryMoved((MoveOperationContext)opContext);
                    }
                });
                break;
            }
            case RENAME: {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.entryRenamed((RenameOperationContext)opContext);
                    }
                });
            }
        }
    }

    public void add(AddOperationContext addContext) throws LdapException {
        this.next(addContext);
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(addContext.getDn(), addContext.getEntry());
        if (selecting.isEmpty()) {
            return;
        }
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isAdd((int)registration.getCriteria().getEventMask())) continue;
            this.fire((OperationContext)addContext, EventType.ADD, registration.getListener());
        }
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(deleteContext.getDn(), deleteContext.getEntry());
        this.next(deleteContext);
        if (selecting.isEmpty()) {
            return;
        }
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isDelete((int)registration.getCriteria().getEventMask())) continue;
            this.fire((OperationContext)deleteContext, EventType.DELETE, registration.getListener());
        }
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Entry oriEntry = modifyContext.getEntry();
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(modifyContext.getDn(), oriEntry);
        this.next(modifyContext);
        if (selecting.isEmpty()) {
            return;
        }
        CoreSession session = modifyContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, modifyContext.getDn());
        lookupContext.setAttrsId(SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry alteredEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        modifyContext.setAlteredEntry(alteredEntry);
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isModify((int)registration.getCriteria().getEventMask())) continue;
            this.fire((OperationContext)modifyContext, EventType.MODIFY, registration.getListener());
        }
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        Entry oriEntry = moveContext.getOriginalEntry();
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(moveContext.getDn(), oriEntry);
        this.next(moveContext);
        if (selecting.isEmpty()) {
            return;
        }
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isMove((int)registration.getCriteria().getEventMask())) continue;
            this.fire((OperationContext)moveContext, EventType.MOVE, registration.getListener());
        }
    }

    public void moveAndRename(final MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Entry oriEntry = moveAndRenameContext.getOriginalEntry();
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(moveAndRenameContext.getDn(), oriEntry);
        this.next(moveAndRenameContext);
        if (selecting.isEmpty()) {
            return;
        }
        for (final RegistrationEntry registration : selecting) {
            if (!EventType.isMoveAndRename((int)registration.getCriteria().getEventMask())) continue;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    registration.getListener().entryMovedAndRenamed(moveAndRenameContext);
                }
            });
        }
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        Entry oriEntry = ((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry();
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(renameContext.getDn(), oriEntry);
        this.next(renameContext);
        if (selecting.isEmpty()) {
            return;
        }
        CoreSession session = renameContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, renameContext.getNewDn());
        lookupContext.setAttrsId(SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry alteredEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        renameContext.setModifiedEntry(alteredEntry);
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isRename((int)registration.getCriteria().getEventMask())) continue;
            this.fire((OperationContext)renameContext, EventType.RENAME, registration.getListener());
        }
    }

    private List<RegistrationEntry> getSelectingRegistrations(Dn name, Entry entry) throws LdapException {
        if (this.directoryService.getEventService().getRegistrationEntries().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegistrationEntry> selecting = new ArrayList<RegistrationEntry>();
        for (RegistrationEntry registration : this.directoryService.getEventService().getRegistrationEntries()) {
            NotificationCriteria criteria = registration.getCriteria();
            Dn base = criteria.getBase();
            if (!name.equals((Object)base) && !name.isDescendantOf(base) || !this.evaluator.evaluate(criteria.getFilter(), base, entry)) continue;
            selecting.add(registration);
        }
        return selecting;
    }
}

