/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.normalization;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.BranchNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.model.filter.FilterVisitor;
import org.apache.directory.shared.ldap.model.filter.LeafNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.filter.SimpleNode;
import org.apache.directory.shared.ldap.model.filter.SubstringNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.normalizers.NameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterNormalizingVisitor
implements FilterVisitor {
    private static final Logger log = LoggerFactory.getLogger(FilterNormalizingVisitor.class);
    private final NameComponentNormalizer ncn;
    private final SchemaManager schemaManager;
    private static final boolean[] FILTER_CHAR = new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public static boolean isFilterChar(char c) {
        return (c | 0x7F) == 127 && FILTER_CHAR[c & 0x7F];
    }

    public FilterNormalizingVisitor(NameComponentNormalizer ncn, SchemaManager schemaManager) {
        this.ncn = ncn;
        this.schemaManager = schemaManager;
    }

    private Value<?> normalizeValue(AttributeType attributeType, Value<?> value) {
        try {
            Object normalized = null;
            normalized = attributeType.getSyntax().isHumanReadable() ? new StringValue((String)this.ncn.normalizeByName(attributeType.getOid(), value.getString())) : (Value)this.ncn.normalizeByName(attributeType.getOid(), value.getBytes());
            return normalized;
        }
        catch (LdapException ne) {
            log.warn("Failed to normalize filter value: {}", (Object)ne.getLocalizedMessage(), (Object)ne);
            return null;
        }
    }

    private ExprNode visitPresenceNode(PresenceNode node) throws LdapException {
        if (!this.ncn.isDefined(node.getAttribute())) {
            return null;
        }
        node.setAttributeType(this.schemaManager.lookupAttributeTypeRegistry(node.getAttribute()));
        return node;
    }

    private ExprNode visitSimpleNode(SimpleNode node) throws LdapException {
        Value<?> normalized;
        if (node.getAttributeType() == null) {
            if (!this.ncn.isDefined(node.getAttribute())) {
                return null;
            }
            node.setAttributeType(this.schemaManager.lookupAttributeTypeRegistry(node.getAttribute()));
        }
        if ((normalized = this.normalizeValue(node.getAttributeType(), node.getValue())) == null) {
            return null;
        }
        node.setValue(normalized);
        return node;
    }

    private ExprNode visitSubstringNode(SubstringNode node) throws LdapException {
        if (!this.ncn.isDefined(node.getAttribute())) {
            return null;
        }
        node.setAttributeType(this.schemaManager.lookupAttributeTypeRegistry(node.getAttribute()));
        Value<?> normInitial = null;
        if (node.getInitial() != null && (normInitial = this.normalizeValue(node.getAttributeType(), (Value<?>)new StringValue(node.getInitial()))) == null) {
            return null;
        }
        ArrayList<String> normAnys = null;
        if (node.getAny() != null && node.getAny().size() != 0) {
            normAnys = new ArrayList<String>(node.getAny().size());
            for (String any : node.getAny()) {
                Value<?> normAny = this.normalizeValue(node.getAttributeType(), (Value<?>)new StringValue(any));
                if (normAny == null) continue;
                normAnys.add(normAny.getString());
            }
            if (normAnys.size() == 0) {
                return null;
            }
        }
        Value<?> normFinal = null;
        if (node.getFinal() != null && (normFinal = this.normalizeValue(node.getAttributeType(), (Value<?>)new StringValue(node.getFinal()))) == null) {
            return null;
        }
        if (normInitial != null) {
            node.setInitial(normInitial.getString());
        } else {
            node.setInitial(null);
        }
        node.setAny(normAnys);
        if (normFinal != null) {
            node.setFinal(normFinal.getString());
        } else {
            node.setFinal(null);
        }
        return node;
    }

    private ExprNode visitExtensibleNode(ExtensibleNode node) throws LdapException {
        if (!this.ncn.isDefined(node.getAttribute())) {
            return null;
        }
        node.setAttributeType(this.schemaManager.lookupAttributeTypeRegistry(node.getAttribute()));
        return node;
    }

    private ExprNode visitBranchNode(BranchNode node) {
        if (node instanceof NotNode) {
            ExprNode child = node.getFirstChild();
            ExprNode result = (ExprNode)this.visit(child);
            if (result == null) {
                return null;
            }
            if (result instanceof BranchNode) {
                ArrayList<ExprNode> newChildren = new ArrayList<ExprNode>(1);
                newChildren.add(result);
                node.setChildren(newChildren);
                return node;
            }
            if (result instanceof LeafNode) {
                ArrayList<ExprNode> newChildren = new ArrayList<ExprNode>(1);
                newChildren.add(result);
                node.setChildren(newChildren);
                return node;
            }
        } else {
            BranchNode branchNode = node;
            List children = node.getChildren();
            ArrayList<ExprNode> newChildren = new ArrayList<ExprNode>(children.size());
            for (int i = 0; i < children.size(); ++i) {
                ExprNode child = (ExprNode)children.get(i);
                ExprNode result = (ExprNode)this.visit(child);
                if (result == null) continue;
                newChildren.add(result);
            }
            if (branchNode instanceof AndNode && newChildren.size() != children.size()) {
                return null;
            }
            if (newChildren.size() == 0) {
                return null;
            }
            if (newChildren.size() == 1) {
                return (ExprNode)newChildren.get(0);
            }
            branchNode.setChildren(newChildren);
        }
        return node;
    }

    public Object visit(ExprNode node) {
        try {
            if (node instanceof PresenceNode) {
                return this.visitPresenceNode((PresenceNode)node);
            }
            if (node instanceof BranchNode) {
                return this.visitBranchNode((BranchNode)node);
            }
            if (node instanceof SimpleNode) {
                return this.visitSimpleNode((SimpleNode)node);
            }
            if (node instanceof ExtensibleNode) {
                return this.visitExtensibleNode((ExtensibleNode)node);
            }
            if (node instanceof SubstringNode) {
                return this.visitSubstringNode((SubstringNode)node);
            }
            return null;
        }
        catch (LdapException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canVisit(ExprNode node) {
        return true;
    }

    public boolean isPrefix() {
        return false;
    }

    public List<ExprNode> getOrder(BranchNode node, List<ExprNode> children) {
        return children;
    }
}

