/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

public class ClonedServerEntry
implements Entry {
    protected Entry originalEntry;
    protected Entry clonedEntry;

    public ClonedServerEntry() {
    }

    public ClonedServerEntry(Entry originalEntry) {
        this.originalEntry = originalEntry;
        this.clonedEntry = originalEntry.clone();
    }

    public Entry getOriginalEntry() {
        return this.originalEntry;
    }

    public Entry getClonedEntry() {
        return this.clonedEntry;
    }

    public void add(AttributeType attributeType, byte[] ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(AttributeType attributeType, String ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(AttributeType attributeType, Value<?> ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(String upId, AttributeType attributeType, String ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public boolean contains(AttributeType attributeType, byte[] ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    public boolean contains(AttributeType attributeType, String ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    public boolean contains(AttributeType attributeType, Value<?> ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    public boolean containsAttribute(AttributeType attributeType) {
        return this.clonedEntry.containsAttribute(attributeType);
    }

    public Attribute get(AttributeType attributeType) {
        return this.clonedEntry.get(attributeType);
    }

    public Collection<Attribute> getAttributes() {
        return this.clonedEntry.getAttributes();
    }

    public boolean hasObjectClass(Attribute ... objectClasses) {
        return this.clonedEntry.hasObjectClass(objectClasses);
    }

    public Attribute put(AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    public Attribute put(AttributeType attributeType, String ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    public Attribute put(AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    public Attribute put(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    public Attribute put(String upId, AttributeType attributeType, String ... values) throws LdapException {
        return this.clonedEntry.put(upId, attributeType, values);
    }

    public Attribute put(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.clonedEntry.put(upId, attributeType, values);
    }

    public boolean remove(AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.clonedEntry.remove(attributeType, values);
    }

    public boolean remove(AttributeType attributeType, String ... values) throws LdapException {
        return this.clonedEntry.remove(attributeType, values);
    }

    public boolean remove(AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.clonedEntry.remove(attributeType, values);
    }

    public List<Attribute> remove(Attribute ... attributes) throws LdapException {
        return this.clonedEntry.remove(attributes);
    }

    public List<Attribute> removeAttributes(AttributeType ... attributes) {
        return this.clonedEntry.removeAttributes(attributes);
    }

    public void add(Attribute ... attributes) throws LdapException {
        this.clonedEntry.add(attributes);
    }

    public void add(String upId, String ... values) throws LdapException {
        this.clonedEntry.add(upId, values);
    }

    public void add(String upId, byte[] ... values) throws LdapException {
        this.clonedEntry.add(upId, values);
    }

    public void add(String upId, Value<?> ... values) throws LdapException {
        this.clonedEntry.add(upId, values);
    }

    public void clear() {
        this.clonedEntry.clear();
    }

    public boolean contains(Attribute ... attributes) {
        return this.clonedEntry.contains(attributes);
    }

    public boolean contains(String upId, byte[] ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    public boolean contains(String upId, String ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    public boolean contains(String upId, Value<?> ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    public boolean containsAttribute(String ... attributes) {
        return this.clonedEntry.containsAttribute(attributes);
    }

    public Attribute get(String alias) {
        return this.clonedEntry.get(alias);
    }

    public Dn getDn() {
        return this.clonedEntry.getDn();
    }

    public boolean hasObjectClass(String ... objectClasses) {
        return this.clonedEntry.hasObjectClass(objectClasses);
    }

    public boolean isSchemaAware() {
        return this.clonedEntry.isSchemaAware();
    }

    public Iterator<Attribute> iterator() {
        return this.clonedEntry.iterator();
    }

    public List<Attribute> put(Attribute ... attributes) throws LdapException {
        return this.clonedEntry.put(attributes);
    }

    public Attribute put(String upId, byte[] ... values) {
        return this.clonedEntry.put(upId, values);
    }

    public Attribute put(String upId, String ... values) {
        return this.clonedEntry.put(upId, values);
    }

    public Attribute put(String upId, Value<?> ... values) {
        return this.clonedEntry.put(upId, values);
    }

    public boolean remove(String upId, byte[] ... values) throws LdapException {
        return this.clonedEntry.remove(upId, values);
    }

    public boolean remove(String upId, String ... values) throws LdapException {
        return this.clonedEntry.remove(upId, values);
    }

    public boolean remove(String upId, Value<?> ... values) throws LdapException {
        return this.clonedEntry.remove(upId, values);
    }

    public List<Attribute> removeAttributes(String ... attributes) {
        return this.clonedEntry.removeAttributes(attributes);
    }

    public void setDn(Dn dn) {
        this.clonedEntry.setDn(dn);
    }

    public void setDn(String dn) throws LdapInvalidDnException {
        this.clonedEntry.setDn(dn);
    }

    public int size() {
        return this.clonedEntry.size();
    }

    public Entry toClientEntry() throws LdapException {
        DefaultEntry clientEntry = new DefaultEntry(this.clonedEntry.getDn());
        Iterator<Attribute> i$ = this.iterator();
        while (i$.hasNext()) {
            Attribute clonedEntry = i$.next();
            Attribute clientAttribute = clonedEntry.clone();
            clientEntry.add(new Attribute[]{clientAttribute});
        }
        return clientEntry;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException(I18n.err((I18n)I18n.ERR_455, (Object[])new Object[0]));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException(I18n.err((I18n)I18n.ERR_456, (Object[])new Object[0]));
    }

    public Entry clone() {
        return this.clonedEntry.clone();
    }

    public int hashCode() {
        return 703;
    }

    public boolean equals(Object obj) {
        Entry other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClonedServerEntry) {
            other = ((ClonedServerEntry)obj).getClonedEntry();
        } else if (obj instanceof Entry) {
            other = (Entry)obj;
        } else {
            return false;
        }
        if (this.clonedEntry == null) {
            return other == null;
        }
        return this.clonedEntry.equals(other);
    }

    public String toString() {
        return this.clonedEntry.toString();
    }
}

