/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.authn;

import org.apache.directory.shared.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.shared.util.Strings;

public class EncryptionMethod {
    private byte[] salt;
    private LdapSecurityConstants algorithm;

    EncryptionMethod(LdapSecurityConstants algorithm, byte[] salt) {
        this.algorithm = algorithm;
        this.salt = salt;
    }

    public LdapSecurityConstants getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    void setSalt(byte[] salt) {
        if (this.salt != null) {
            throw new IllegalStateException("salt will only be allowed to set once");
        }
        this.salt = salt;
    }

    public String toString() {
        return "EncryptionMethod [algorithm=" + this.algorithm.getName().toUpperCase() + ", salt=" + Strings.dumpBytes((byte[])this.salt) + "]";
    }
}

