/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.util.Iterator;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.SearchCursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.IntermediateResponse;
import org.apache.directory.shared.ldap.model.message.Referral;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchResultDoneImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultEntryImpl;

public class EntryToResponseCursor
implements SearchCursor {
    private Cursor<Entry> wrapped;
    private SearchResultDone searchDoneResp;
    private boolean done;
    private int messageId;

    public EntryToResponseCursor(int messageId, Cursor<Entry> wrapped) {
        this.wrapped = wrapped;
        this.messageId = messageId;
    }

    public Iterator<Response> iterator() {
        throw new UnsupportedOperationException();
    }

    public void after(Response resp) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void afterLast() throws Exception {
        this.wrapped.afterLast();
    }

    public boolean available() {
        return this.wrapped.available();
    }

    public void before(Response resp) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws Exception {
        this.wrapped.beforeFirst();
    }

    public void close() throws Exception {
        this.wrapped.close();
    }

    public void close(Exception e) throws Exception {
        this.wrapped.close(e);
    }

    public boolean first() throws Exception {
        return this.wrapped.first();
    }

    public Response get() throws Exception {
        ClonedServerEntry entry = (ClonedServerEntry)this.wrapped.get();
        SearchResultEntryImpl se = new SearchResultEntryImpl(this.messageId);
        se.setEntry((Entry)entry);
        return se;
    }

    public SearchResultDone getSearchResultDone() {
        return this.searchDoneResp;
    }

    public boolean isClosed() throws Exception {
        return this.wrapped.isClosed();
    }

    public boolean last() throws Exception {
        return this.wrapped.last();
    }

    public boolean next() throws Exception {
        this.done = this.wrapped.next();
        if (!this.done) {
            this.searchDoneResp = new SearchResultDoneImpl(this.messageId);
            this.searchDoneResp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        }
        return this.done;
    }

    public boolean previous() throws Exception {
        return this.wrapped.previous();
    }

    public void setClosureMonitor(ClosureMonitor monitor) {
        this.wrapped.setClosureMonitor(monitor);
    }

    public boolean isAfterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isAfterLast()")}));
    }

    public boolean isBeforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isBeforeFirst()")}));
    }

    public boolean isFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isFirst()")}));
    }

    public boolean isLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isLast()")}));
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isReferral() {
        return false;
    }

    public Referral getReferral() throws LdapException {
        throw new LdapException();
    }

    public boolean isEntry() {
        return true;
    }

    public Entry getEntry() throws LdapException {
        if (!this.done && this.wrapped.available()) {
            try {
                return (Entry)this.wrapped.get();
            }
            catch (Exception e) {
                throw new LdapException((Throwable)e);
            }
        }
        throw new LdapException();
    }

    public boolean isIntermediate() {
        return false;
    }

    public IntermediateResponse getIntermediate() throws LdapException {
        throw new LdapException();
    }
}

