/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import java.util.List;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxCheckerSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(SyntaxCheckerSynchronizer.class);

    public SyntaxCheckerSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    public boolean modify(ModifyOperationContext opContext, ServerEntry targetEntry, boolean cascade) throws Exception {
        DN name = opContext.getDn();
        ClonedServerEntry entry = opContext.getEntry();
        String schemaName = this.getSchemaName(name);
        String oid = this.getOid((ServerEntry)entry);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, (Entry)targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            syntaxChecker.setSchemaName(schemaName);
            this.schemaManager.unregisterSyntaxChecker(oid);
            this.schemaManager.add((SchemaObject)syntaxChecker);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(ServerEntry entry) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "SyntaxChecker");
        this.checkOidIsUniqueForSyntaxChecker(entry);
        String schemaName = this.getSchemaName(dn);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, (Entry)entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && syntaxChecker.isEnabled()) {
            if (this.schemaManager.add((SchemaObject)syntaxChecker)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err((String)I18n.ERR_386, (Object[])new Object[]{entry.getDn().getName(), StringTools.listToString((List)this.schemaManager.getErrors())});
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The SyntaxChecker {} cannot be added in the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(ServerEntry entry, boolean cascade) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "SyntaxChecker");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The SyntaxChecker {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        SyntaxChecker syntaxChecker = null;
        try {
            syntaxChecker = this.checkSyntaxCheckerOidExists(entry);
        }
        catch (LdapSchemaViolationException lsve) {
            syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, (Entry)entry, this.schemaManager.getRegistries(), schemaName);
            if (this.schemaManager.getRegistries().contains((SchemaObject)syntaxChecker)) {
                this.schemaManager.getRegistries().dissociateFromSchema((SchemaObject)syntaxChecker);
                return;
            }
            String msg = I18n.err((String)I18n.ERR_387, (Object[])new Object[]{entry.getDn().getName()});
            LOG.info(msg);
            throw new LdapSchemaViolationException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        if (schema.isEnabled() && syntaxChecker.isEnabled()) {
            if (this.schemaManager.delete((SchemaObject)syntaxChecker)) {
                LOG.debug("Deleted {} from the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err((String)I18n.ERR_386, (Object[])new Object[]{entry.getDn().getName(), StringTools.listToString((List)this.schemaManager.getErrors())});
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The syntaxChecker {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    public void rename(ServerEntry entry, RDN newRdn, boolean cascade) throws Exception {
        String oldOid = this.getOid(entry);
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.schemaManager.getLdapSyntaxRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((String)I18n.ERR_389, (Object[])new Object[]{oldOid}));
        }
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = newRdn.getNormValue();
        if (this.schemaManager.getSyntaxCheckerRegistry().contains(newOid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err((String)I18n.ERR_390, (Object[])new Object[]{newOid}));
        }
        targetEntry.put("m-oid", new String[]{newOid});
        if (this.isSchemaEnabled(schemaName)) {
            SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, (Entry)targetEntry, this.schemaManager.getRegistries(), schemaName);
            this.schemaManager.unregisterSyntaxChecker(oldOid);
            this.schemaManager.add((SchemaObject)syntaxChecker);
        }
    }

    public void moveAndRename(DN oriChildName, DN newParentName, RDN newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getLdapSyntaxRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((String)I18n.ERR_391, (Object[])new Object[]{oldOid}));
        }
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = newRdn.getNormValue();
        if (this.schemaManager.getSyntaxCheckerRegistry().contains(newOid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err((String)I18n.ERR_390, (Object[])new Object[]{newOid}));
        }
        targetEntry.put("m-oid", new String[]{newOid});
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, (Entry)targetEntry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterSyntaxChecker(oldOid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add((SchemaObject)syntaxChecker);
        }
    }

    public void move(DN oriChildName, DN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getLdapSyntaxRegistry().contains(oid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((String)I18n.ERR_393, (Object[])new Object[]{oid}));
        }
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, (Entry)entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterSyntaxChecker(oid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add((SchemaObject)syntaxChecker);
        }
    }

    private void checkOidIsUniqueForSyntaxChecker(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.schemaManager.getNormalizerRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err((String)I18n.ERR_390, (Object[])new Object[]{oid}));
        }
    }

    protected SyntaxChecker checkSyntaxCheckerOidExists(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.schemaManager.getSyntaxCheckerRegistry().contains(oid)) {
            return (SyntaxChecker)this.schemaManager.getSyntaxCheckerRegistry().get(oid);
        }
        throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err((String)I18n.ERR_336, (Object[])new Object[]{oid}));
    }

    private void checkNewParent(DN newParent) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err((String)I18n.ERR_396, (Object[])new Object[0]));
        }
        RDN rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err((String)I18n.ERR_397, (Object[])new Object[0]));
        }
        if (!rdn.getNormValue().equalsIgnoreCase("syntaxCheckers")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err((String)I18n.ERR_372, (Object[])new Object[0]));
        }
    }
}

