/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.message.internal.InternalModifyRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyOperationContext
extends AbstractChangeOperationContext {
    private List<Modification> modItems;
    private ClonedServerEntry alteredEntry;

    public ModifyOperationContext(CoreSession session) {
        super(session);
    }

    public ModifyOperationContext(CoreSession session, DN dn, List<Modification> modItems) {
        super(session, dn);
        this.modItems = modItems;
    }

    public ModifyOperationContext(CoreSession session, InternalModifyRequest modifyRequest) throws Exception {
        super(session, modifyRequest.getName());
        this.modItems = ServerEntryUtils.toServerModification((Modification[])((Modification[])modifyRequest.getModificationItems().toArray(new ClientModification[0])), (SchemaManager)session.getDirectoryService().getSchemaManager());
        this.requestControls = modifyRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public void setModItems(List<Modification> modItems) {
        this.modItems = modItems;
    }

    public List<Modification> getModItems() {
        return this.modItems;
    }

    public static List<Modification> createModItems(ServerEntry serverEntry, ModificationOperation modOp) throws NamingException {
        ArrayList<Modification> items = new ArrayList<Modification>(serverEntry.size());
        for (EntryAttribute attribute : serverEntry) {
            items.add((Modification)new ServerModification(modOp, attribute));
        }
        return items;
    }

    @Override
    public String getName() {
        return MessageTypeEnum.MODIFY_REQUEST.name();
    }

    public ClonedServerEntry getAlteredEntry() {
        return this.alteredEntry;
    }

    public void setAlteredEntry(ClonedServerEntry alteredEntry) {
        this.alteredEntry = alteredEntry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ModifyContext for DN '").append(this.getDn().getName()).append("', modifications :\n");
        if (this.modItems != null) {
            for (Modification mod : this.modItems) {
                sb.append(mod).append('\n');
            }
        }
        return sb.toString();
    }
}

