/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.ConfigurationException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.InterceptorException;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.name.DN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorChain {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final Interceptor FINAL_INTERCEPTOR = new Interceptor(){
        private PartitionNexus nexus;

        @Override
        public String getName() {
            return "FINAL";
        }

        @Override
        public void init(DirectoryService directoryService) {
            this.nexus = directoryService.getPartitionNexus();
        }

        @Override
        public void destroy() {
        }

        @Override
        public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws Exception {
            return this.nexus.compare(opContext);
        }

        @Override
        public ClonedServerEntry getRootDSE(NextInterceptor next, GetRootDSEOperationContext opContext) throws Exception {
            return this.nexus.getRootDSE(opContext);
        }

        @Override
        public DN getMatchedName(NextInterceptor next, GetMatchedNameOperationContext opContext) throws Exception {
            return (DN)this.nexus.getMatchedName(opContext).clone();
        }

        @Override
        public DN getSuffix(NextInterceptor next, GetSuffixOperationContext opContext) throws Exception {
            return (DN)this.nexus.getSuffix(opContext).clone();
        }

        @Override
        public Set<String> listSuffixes(NextInterceptor next, ListSuffixOperationContext opContext) throws Exception {
            return this.nexus.listSuffixes(opContext);
        }

        @Override
        public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
            this.nexus.delete(opContext);
        }

        @Override
        public void add(NextInterceptor next, AddOperationContext opContext) throws Exception {
            this.nexus.add(opContext);
        }

        @Override
        public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
            this.nexus.modify(opContext);
        }

        @Override
        public EntryFilteringCursor list(NextInterceptor next, ListOperationContext opContext) throws Exception {
            return this.nexus.list(opContext);
        }

        @Override
        public EntryFilteringCursor search(NextInterceptor next, SearchOperationContext opContext) throws Exception {
            return this.nexus.search(opContext);
        }

        @Override
        public ClonedServerEntry lookup(NextInterceptor next, LookupOperationContext opContext) throws Exception {
            return this.nexus.lookup(opContext);
        }

        @Override
        public boolean hasEntry(NextInterceptor next, EntryOperationContext opContext) throws Exception {
            return this.nexus.hasEntry(opContext);
        }

        @Override
        public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
            this.nexus.rename(opContext);
        }

        @Override
        public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
            this.nexus.move(opContext);
        }

        @Override
        public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
            this.nexus.moveAndRename(opContext);
        }

        @Override
        public void addContextPartition(NextInterceptor next, AddContextPartitionOperationContext opContext) throws Exception {
            this.nexus.addContextPartition(opContext);
        }

        @Override
        public void removeContextPartition(NextInterceptor next, RemoveContextPartitionOperationContext opContext) throws Exception {
            this.nexus.removeContextPartition(opContext);
        }

        @Override
        public void bind(NextInterceptor next, BindOperationContext opContext) throws Exception {
            this.nexus.bind(opContext);
        }

        @Override
        public void unbind(NextInterceptor next, UnbindOperationContext opContext) throws Exception {
            this.nexus.unbind(opContext);
        }
    };
    private final Map<String, Entry> name2entry = new HashMap<String, Entry>();
    private final Entry tail;
    private Entry head = this.tail = new Entry("tail", null, null, this.FINAL_INTERCEPTOR);
    private DirectoryService directoryService;

    public synchronized void init(DirectoryService directoryService) throws Exception {
        this.directoryService = directoryService;
        this.FINAL_INTERCEPTOR.init(directoryService);
        try {
            for (Interceptor interceptor : directoryService.getInterceptors()) {
                if (IS_DEBUG) {
                    LOG.debug("Adding interceptor " + interceptor.getName());
                }
                this.register(interceptor);
            }
        }
        catch (Throwable t) {
            this.destroy();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new InterceptorException(null, I18n.err((String)I18n.ERR_329, (Object[])new Object[0]), t);
        }
    }

    public synchronized void destroy() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Entry e = this.tail;
        do {
            entries.add(e);
        } while ((e = e.prevEntry) != null);
        for (Entry entry : entries) {
            if (entry == this.tail) continue;
            try {
                this.deregister(entry.getName());
            }
            catch (Throwable t) {
                LOG.warn("Failed to deregister an interceptor: " + entry.getName(), t);
            }
        }
    }

    public Interceptor get(String interceptorName) {
        Entry e = this.name2entry.get(interceptorName);
        if (e == null) {
            return null;
        }
        return e.interceptor;
    }

    public synchronized List<Interceptor> getAll() {
        ArrayList<Interceptor> result = new ArrayList<Interceptor>();
        Entry e = this.head;
        do {
            result.add(e.interceptor);
        } while ((e = e.nextEntry) != this.tail);
        return result;
    }

    public synchronized void addFirst(Interceptor interceptor) throws Exception {
        this.register0(interceptor, this.head);
    }

    public synchronized void addLast(Interceptor interceptor) throws Exception {
        this.register0(interceptor, this.tail);
    }

    public synchronized void addBefore(String nextInterceptorName, Interceptor interceptor) throws Exception {
        Entry e = this.name2entry.get(nextInterceptorName);
        if (e == null) {
            throw new ConfigurationException(I18n.err((String)I18n.ERR_330, (Object[])new Object[]{nextInterceptorName}));
        }
        this.register0(interceptor, e);
    }

    public synchronized String remove(String interceptorName) throws Exception {
        return this.deregister(interceptorName);
    }

    public synchronized void addAfter(String prevInterceptorName, Interceptor interceptor) throws Exception {
        Entry e = this.name2entry.get(prevInterceptorName);
        if (e == null) {
            throw new ConfigurationException(I18n.err((String)I18n.ERR_330, (Object[])new Object[]{prevInterceptorName}));
        }
        this.register0(interceptor, e.nextEntry);
    }

    private void register(Interceptor interceptor) throws Exception {
        this.checkAddable(interceptor);
        this.register0(interceptor, this.tail);
    }

    private String deregister(String name) throws ConfigurationException {
        Entry entry = this.checkOldName(name);
        Entry prevEntry = entry.prevEntry;
        Entry nextEntry = entry.nextEntry;
        if (nextEntry == null) {
            return null;
        }
        if (prevEntry == null) {
            nextEntry.prevEntry = null;
            this.head = nextEntry;
        } else {
            prevEntry.nextEntry = nextEntry;
            nextEntry.prevEntry = prevEntry;
        }
        this.name2entry.remove(name);
        entry.interceptor.destroy();
        return entry.getName();
    }

    private void register0(Interceptor interceptor, Entry nextEntry) throws Exception {
        Entry newEntry;
        String name = interceptor.getName();
        interceptor.init(this.directoryService);
        if (nextEntry == this.head) {
            newEntry = new Entry(interceptor.getName(), null, this.head, interceptor);
            this.head.prevEntry = newEntry;
            this.head = newEntry;
        } else if (this.head == this.tail) {
            newEntry = new Entry(interceptor.getName(), null, this.tail, interceptor);
            this.tail.prevEntry = newEntry;
            this.head = newEntry;
        } else {
            newEntry = new Entry(interceptor.getName(), nextEntry.prevEntry, nextEntry, interceptor);
            nextEntry.prevEntry.nextEntry = newEntry;
            nextEntry.prevEntry = newEntry;
        }
        this.name2entry.put(name, newEntry);
    }

    private Entry checkOldName(String name) throws ConfigurationException {
        Entry e = this.name2entry.get(name);
        if (e == null) {
            throw new ConfigurationException(I18n.err((String)I18n.ERR_331, (Object[])new Object[]{name}));
        }
        return e;
    }

    private void checkAddable(Interceptor interceptor) throws ConfigurationException {
        if (this.name2entry.containsKey(interceptor.getName())) {
            throw new ConfigurationException(I18n.err((String)I18n.ERR_332, (Object[])new Object[]{interceptor.getName()}));
        }
    }

    private Entry getStartingEntry() {
        if (InvocationStack.getInstance().isEmpty()) {
            return this.head;
        }
        OperationContext opContext = InvocationStack.getInstance().peek();
        if (!opContext.hasBypass()) {
            return this.head;
        }
        if (opContext.isBypassed("*")) {
            return this.tail;
        }
        Entry next = this.head;
        while (next != this.tail) {
            if (opContext.isBypassed(next.getName())) {
                next = next.nextEntry;
                continue;
            }
            return next;
        }
        return this.tail;
    }

    public ClonedServerEntry getRootDSE(GetRootDSEOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getRootDSE(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public DN getMatchedName(GetMatchedNameOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getMatchedName(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public DN getSuffix(GetSuffixOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getSuffix(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public boolean compare(CompareOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.compare(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public Set<String> listSuffixes(ListSuffixOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.listSuffixes(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void addContextPartition(AddContextPartitionOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.addContextPartition(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void removeContextPartition(RemoveContextPartitionOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.removeContextPartition(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    private void eagerlyPopulateFields(OperationContext opContext) {
        if (opContext.getEntry() == null) {
            try {
                CoreSession adminSession = opContext.getSession().getDirectoryService().getAdminSession();
                opContext.setEntry(adminSession.lookup(opContext.getDn(), SchemaConstants.ALL_OPERATIONAL_ATTRIBUTES_ARRAY));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void delete(DeleteOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(opContext);
        try {
            head.delete(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void add(AddOperationContext opContext) throws Exception {
        Entry node = this.getStartingEntry();
        Interceptor head = node.interceptor;
        NextInterceptor next = node.nextInterceptor;
        try {
            head.add(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void bind(BindOperationContext opContext) throws Exception {
        Entry node = this.getStartingEntry();
        Interceptor head = node.interceptor;
        NextInterceptor next = node.nextInterceptor;
        this.eagerlyPopulateFields(opContext);
        try {
            head.bind(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void unbind(UnbindOperationContext opContext) throws Exception {
        Entry node = this.getStartingEntry();
        Interceptor head = node.interceptor;
        NextInterceptor next = node.nextInterceptor;
        try {
            head.unbind(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void modify(ModifyOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(opContext);
        try {
            head.modify(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(opContext);
        try {
            return head.list(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(opContext);
        try {
            return head.search(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.lookup(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public boolean hasEntry(EntryOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.hasEntry(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void rename(RenameOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(opContext);
        try {
            head.rename(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void move(MoveOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(opContext);
        try {
            head.move(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void moveAndRename(MoveAndRenameOperationContext opContext) throws Exception {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        this.eagerlyPopulateFields(opContext);
        try {
            head.moveAndRename(next, opContext);
        }
        catch (Exception ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    private static void throwInterceptorException(Interceptor interceptor, Throwable e) throws InterceptorException {
        throw new InterceptorException(interceptor, I18n.err((String)I18n.ERR_333, (Object[])new Object[0]), e);
    }

    private class Entry {
        private volatile Entry prevEntry;
        private volatile Entry nextEntry;
        private final String name;
        private final Interceptor interceptor;
        private final NextInterceptor nextInterceptor;

        private String getName() {
            return this.name;
        }

        private Entry(String name, Entry prevEntry, Entry nextEntry, Interceptor interceptor) {
            this.name = name;
            if (interceptor == null) {
                throw new NullPointerException("interceptor");
            }
            this.prevEntry = prevEntry;
            this.nextEntry = nextEntry;
            this.interceptor = interceptor;
            this.nextInterceptor = new NextInterceptor(){

                private Entry getNextEntry() {
                    if (InvocationStack.getInstance().isEmpty()) {
                        return Entry.this.nextEntry;
                    }
                    OperationContext opContext = InvocationStack.getInstance().peek();
                    if (!opContext.hasBypass()) {
                        return Entry.this.nextEntry;
                    }
                    Entry next = Entry.this.nextEntry;
                    while (next != InterceptorChain.this.tail) {
                        if (opContext.isBypassed(next.getName())) {
                            next = next.nextEntry;
                            continue;
                        }
                        return next;
                    }
                    return next;
                }

                @Override
                public boolean compare(CompareOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.compare(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public ClonedServerEntry getRootDSE(GetRootDSEOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.getRootDSE(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public DN getMatchedName(GetMatchedNameOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.getMatchedName(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public DN getSuffix(GetSuffixOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.getSuffix(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public Set<String> listSuffixes(ListSuffixOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.listSuffixes(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public void delete(DeleteOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.delete(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void add(AddOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.add(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void modify(ModifyOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.modify(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.list(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.search(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.lookup(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public boolean hasEntry(EntryOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.hasEntry(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public void rename(RenameOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.rename(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void move(MoveOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.move(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void moveAndRename(MoveAndRenameOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.moveAndRename(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void bind(BindOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.bind(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void unbind(UnbindOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.unbind(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void addContextPartition(AddContextPartitionOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.addContextPartition(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public void removeContextPartition(RemoveContextPartitionOperationContext opContext) throws Exception {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.removeContextPartition(next.nextInterceptor, opContext);
                    }
                    catch (Exception ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }
            };
        }
    }
}

